/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.jobs.agent.resources;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Application;
import javax.ws.rs.core.Context;
import org.tiogasolutions.dev.common.IoUtils;
import org.tiogasolutions.dev.common.ReflectUtils;
import org.tiogasolutions.dev.common.exceptions.ApiException;
import org.tiogasolutions.dev.common.exceptions.ApiNotFoundException;
import org.tiogasolutions.dev.domain.query.ListQueryResult;
import org.tiogasolutions.dev.domain.query.QueryResult;
import org.tiogasolutions.jobs.agent.JobsApplication;
import org.tiogasolutions.jobs.agent.entities.JobDefinitionEntity;
import org.tiogasolutions.jobs.agent.entities.JobDefinitionStore;
import org.tiogasolutions.jobs.agent.entities.JobExecutionRequestEntity;
import org.tiogasolutions.jobs.agent.entities.JobExecutionRequestStore;
import org.tiogasolutions.jobs.pub.ActionType;
import org.tiogasolutions.jobs.pub.JobAction;
import org.tiogasolutions.jobs.pub.JobActionResult;
import org.tiogasolutions.jobs.pub.JobDefinition;
import org.tiogasolutions.jobs.pub.JobExecutionRequest;
import org.tiogasolutions.jobs.pub.JobParameters;

public class JobsResourceV1 {
    private static final ExecutorService executor = Executors.newCachedThreadPool();

    @GET
    @Produces(value={"application/json"})
    public QueryResult<JobDefinition> getJobs(@Context Application app) {
        ArrayList jobDefinitions = new ArrayList();
        JobsApplication.get(app, JobDefinitionStore.class).getAll().stream().forEach(jobEntity -> jobDefinitions.add(jobEntity.toJobDefinition()));
        return ListQueryResult.newComplete(JobDefinition.class, jobDefinitions);
    }

    private JobDefinitionEntity loadJob(Application app, String jobDefinitionId) {
        JobDefinitionStore store = JobsApplication.get(app, JobDefinitionStore.class);
        JobDefinitionEntity jobDefinitionEntity = (JobDefinitionEntity)store.getByDocumentId(jobDefinitionId);
        if (jobDefinitionEntity == null) {
            String msg = String.format("The job definition \"%s\" does not exist.", jobDefinitionId);
            throw ApiNotFoundException.notFound((String)msg, (String[])new String[0]);
        }
        return jobDefinitionEntity;
    }

    @GET
    @Path(value="/{jobDefinitionId}")
    @Produces(value={"application/json"})
    public JobDefinition getJob(@Context Application app, @PathParam(value="jobDefinitionId") String jobDefinitionId) throws Exception {
        return this.loadJob(app, jobDefinitionId).toJobDefinition();
    }

    @POST
    @Path(value="/{jobDefinitionId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public JobExecutionRequest execute(@Context Application app, @PathParam(value="jobDefinitionId") String jobDefinitionId, JobParameters jobParameters) throws Exception {
        if (jobParameters == null) {
            throw ApiException.badRequest((String)"The job parameters must be specified.", (String[])new String[0]);
        }
        JobDefinitionEntity jobDefinitionEntity = this.loadJob(app, jobDefinitionId);
        JobExecutionRequestEntity request = JobExecutionRequestEntity.newEntity(jobDefinitionEntity, jobParameters);
        JobsApplication.get(app, JobExecutionRequestStore.class).create(request);
        if (jobParameters.isSynchronous()) {
            return this.executeJob(app, request, jobDefinitionEntity);
        }
        executor.submit(() -> this.executeJob(app, request, jobDefinitionEntity));
        return request.toJobExecutionRequestEntity();
    }

    private JobExecutionRequest executeJob(Application app, JobExecutionRequestEntity request, JobDefinitionEntity jobDefinitionEntity) throws Exception {
        ArrayList<JobActionResult> results = new ArrayList<JobActionResult>();
        for (JobAction jobAction : jobDefinitionEntity.getJobActions()) {
            this.processAction(results, jobAction);
        }
        request.completed(results);
        JobsApplication.get(app, JobExecutionRequestStore.class).update(request);
        return request.toJobExecutionRequestEntity();
    }

    private void processAction(List<JobActionResult> results, JobAction jobAction) throws Exception {
        try {
            ActionType actionType = jobAction.getActionType();
            if (!actionType.isOsCommand()) {
                String msg = String.format("The action type \"%s\" is not supported.", new Object[]{actionType});
                throw new UnsupportedOperationException(msg);
            }
            JobActionResult result = this.processOsCommand(jobAction);
            results.add(result);
        }
        catch (Exception ex) {
            results.add(JobActionResult.fail(ex));
        }
    }

    private JobActionResult processOsCommand(JobAction jobAction) throws Exception {
        String command = jobAction.getCommand();
        List<String> commands = JobsResourceV1.splitCommand(command);
        String[] commandArray = (String[])ReflectUtils.toArray(String.class, commands);
        File workingDir = jobAction.getWorkingDirectory();
        if (!workingDir.exists()) {
            String msg = "The specified working directory does not exist: " + workingDir.getAbsolutePath();
            throw new FileNotFoundException(msg);
        }
        Process process = new ProcessBuilder(new String[0]).command(commandArray).directory(workingDir).redirectErrorStream(true).start();
        process.waitFor(jobAction.getTimeout(), jobAction.getTimeoutUnit());
        int exitValue = process.exitValue();
        String output = IoUtils.toString((InputStream)process.getInputStream());
        return JobActionResult.finished(exitValue, output);
    }

    public static List<String> splitCommand(String command) {
        boolean inString = false;
        ArrayList<String> commands = new ArrayList<String>();
        StringBuilder builder = new StringBuilder();
        for (char chr : command.toCharArray()) {
            if (inString) {
                if (chr != '\"') {
                    builder.append(chr);
                    continue;
                }
                inString = false;
                JobsResourceV1.finish(builder, commands);
                continue;
            }
            if (chr == '\"') {
                inString = true;
                continue;
            }
            if (Character.isWhitespace(chr)) {
                JobsResourceV1.finish(builder, commands);
                continue;
            }
            builder.append(chr);
        }
        JobsResourceV1.finish(builder, commands);
        return commands;
    }

    private static void finish(StringBuilder builder, List<String> commands) {
        if (builder.length() > 0) {
            commands.add(builder.toString());
        }
        builder.delete(0, builder.length());
    }
}

