/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.couchace.core.internal.util;

import java.beans.Introspector;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ClassUtil {
    public static Field findField(Class<?> type, String fieldName) {
        if (type == null || fieldName == null) {
            return null;
        }
        while (type != null && type != Object.class) {
            Field[] fields;
            for (Field field : fields = type.getDeclaredFields()) {
                if (!field.getName().equals(fieldName)) continue;
                return field;
            }
            type = type.getSuperclass();
        }
        return null;
    }

    public static List<Field> listAllFields(Class<?> type) {
        ArrayList<Field> fieldList = new ArrayList<Field>();
        while (type != null && type != Object.class) {
            Field[] fields = type.getDeclaredFields();
            fieldList.addAll(Arrays.asList(fields));
            type = type.getSuperclass();
        }
        return fieldList;
    }

    public static <T extends Annotation> T findClassAnnotation(Class<?> classType, Class<T> annotationType) {
        for (Class<?> type : ClassUtil.listAllClassesAndInterfaces(classType)) {
            T annotation = type.getAnnotation(annotationType);
            if (annotation == null) continue;
            return annotation;
        }
        return null;
    }

    public static List<Class<?>> listAllClassesAndInterfaces(Class<?> type) {
        ArrayList classList = new ArrayList();
        while (type != null && type != Object.class) {
            classList.add(type);
            Collections.addAll(classList, type.getInterfaces());
            type = type.getSuperclass();
        }
        return classList;
    }

    public static Method findSetterMethod(Class<?> type, String propertyName, Class<?> argType) {
        String setterName = "set" + Character.toUpperCase(propertyName.charAt(0)) + propertyName.substring(1);
        while (type != null && type != Object.class) {
            Method[] methods = type.getDeclaredMethods();
            for (Method method : methods) {
                if (!ClassUtil.isSetter(setterName, argType, method)) continue;
                return method;
            }
            for (GenericDeclaration genericDeclaration : type.getInterfaces()) {
                for (Method method : methods = ((Class)genericDeclaration).getDeclaredMethods()) {
                    if (!ClassUtil.isSetter(setterName, argType, method)) continue;
                    return method;
                }
            }
            type = type.getSuperclass();
        }
        return null;
    }

    public static List<Method> listGetterMethods(Class<?> type) {
        ArrayList<Method> methodList = new ArrayList<Method>();
        while (type != null && type != Object.class) {
            Method[] methods = type.getDeclaredMethods();
            for (Method method : methods) {
                if (!ClassUtil.isGetter(method)) continue;
                methodList.add(method);
            }
            for (GenericDeclaration genericDeclaration : type.getInterfaces()) {
                for (Method method : methods = ((Class)genericDeclaration).getDeclaredMethods()) {
                    if (!ClassUtil.isGetter(method)) continue;
                    methodList.add(method);
                }
            }
            type = type.getSuperclass();
        }
        return methodList;
    }

    public static boolean isGetter(Method method) {
        return method.getReturnType() != null && method.getParameterTypes().length == 0 && method.getName().startsWith("get") && method.getName().length() > 3;
    }

    public static boolean isSetter(String setterName, Class<?> argType, Method method) {
        return method.getName().equals(setterName) && method.getReturnType() == null && method.getParameterTypes().length == 1 && method.getParameterTypes()[0].isAssignableFrom(argType);
    }

    public static Map<String, Method> toPropertyMethodMap(Collection<Method> methods) {
        HashMap<String, Method> methodMap = new HashMap<String, Method>();
        for (Method method : methods) {
            String propertyName = Introspector.decapitalize(method.getName().substring(3));
            methodMap.put(propertyName, method);
        }
        return methodMap;
    }
}

