/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.jobs.agent.grizzly;

import java.awt.Desktop;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.ReentrantLock;
import org.glassfish.grizzly.http.server.HttpServer;
import org.glassfish.jersey.grizzly2.httpserver.GrizzlyHttpServerFactory;
import org.glassfish.jersey.server.ResourceConfig;
import org.tiogasolutions.jobs.agent.JobsApplication;
import org.tiogasolutions.jobs.agent.grizzly.JobsResourceConfig;

public class JobsAgent {
    public String serverName = "www.localhost";
    private boolean shutDown = false;
    private int port = 39007;
    private int shutdownPort = 39008;
    private String context = "jobs-server";
    private boolean openBrowser;
    public URI baseUri;
    private HttpServer httpServer;
    private ServerSocket socket;
    private Thread acceptThread;
    private final ReentrantLock handlerLock = new ReentrantLock();
    private static final int socketAcceptTimeoutMilli = 5000;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpServer startServer(String ... args) throws Exception {
        if (args.length % 2 != 0) {
            throw new IllegalArgumentException("Expected an even number of arguments: " + Arrays.asList(args));
        }
        for (int i = 0; i < args.length; i += 2) {
            String key = args[i];
            String value = args[i + 1];
            if ("serverName".equals(key)) {
                this.serverName = value;
                continue;
            }
            if ("port".equals(key)) {
                this.port = Integer.valueOf(value);
                continue;
            }
            if ("shutdown".equals(key)) {
                this.shutdownPort = Integer.valueOf(value);
                continue;
            }
            if ("context".equals(key)) {
                this.context = value;
                continue;
            }
            if ("open".equals(key)) {
                this.openBrowser = Boolean.valueOf(value);
                continue;
            }
            if (!"action".equals(key) || !"stop".equals(value)) continue;
            this.shutDown = true;
        }
        this.baseUri = URI.create("http://" + this.serverName + ":" + this.port + "/" + this.context + "/");
        this.shutdownExisting();
        if (this.shutDown) {
            System.exit(0);
            return null;
        }
        JobsApplication application = new JobsApplication("jobs", "jobs-", "");
        JobsResourceConfig rc = new JobsResourceConfig(application);
        this.httpServer = GrizzlyHttpServerFactory.createHttpServer((URI)this.baseUri, (ResourceConfig)rc);
        this.lockHandler();
        try {
            if (this.acceptThread != null) {
                throw new IllegalStateException("Socket handler thread is already running.");
            }
            try {
                this.socket = new ServerSocket(this.shutdownPort);
                this.socket.setSoTimeout(5000);
                String msg = String.format("%s is accepting connections on port %s from %s.", this.getClass().getSimpleName(), this.shutdownPort, this.socket.getInetAddress().getHostAddress());
                System.out.println(msg);
            }
            catch (IOException ex) {
                String msg = String.format("IOException starting server socket, maybe port %s was not available.", this.shutdownPort);
                System.err.println(msg);
                ex.printStackTrace();
            }
            Thread shutdownThread = new Thread(() -> ((HttpServer)this.httpServer).shutdown(), "shutdownHook");
            Runtime.getRuntime().addShutdownHook(shutdownThread);
            Runnable acceptRun = this::socketAcceptLoop;
            this.acceptThread = new Thread(acceptRun);
            this.acceptThread.start();
        }
        finally {
            this.unlockHandler();
        }
        return this.httpServer;
    }

    private void shutdownExisting() throws IOException {
        try (Socket localSocket = new Socket(this.serverName, this.shutdownPort);
             OutputStream outStream = localSocket.getOutputStream();){
            outStream.write("SHUTDOWN".getBytes());
            outStream.flush();
        }
        catch (ConnectException connectException) {
            // empty catch block
        }
    }

    private void lockHandler() throws TimeoutException, InterruptedException {
        int timeout = 5;
        TimeUnit timeUnit = TimeUnit.SECONDS;
        if (!this.handlerLock.tryLock(timeout, timeUnit)) {
            String msg = String.format("Failed to obtain lock within %s %s", new Object[]{timeout, timeUnit});
            throw new TimeoutException(msg);
        }
    }

    private void unlockHandler() {
        this.handlerLock.unlock();
    }

    public URI getBaseUri() {
        return this.baseUri;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void socketAcceptLoop() {
        block7: while (!Thread.interrupted()) {
            try {
                Thread.sleep(5L);
                this.lockHandler();
                if (this.acceptThread == null || Thread.interrupted()) {
                    System.out.println("Looks like ServordSocketHandler has been stopped, terminate our acceptLoop.");
                    return;
                }
                Socket client = this.socket.accept();
                StringBuilder builder = new StringBuilder();
                InputStream is = client.getInputStream();
                while (true) {
                    int val;
                    if ((val = is.read()) == -1) continue block7;
                    builder.append((char)val);
                    if (!"SHUTDOWN".equals(builder.toString())) continue;
                    System.out.println("Shutdown command received.");
                    this.httpServer.shutdownNow();
                    System.exit(0);
                }
            }
            catch (SocketTimeoutException | TimeoutException ex) {
            }
            catch (Throwable ex) {
                System.out.println("Unexpected exception");
                ex.printStackTrace();
                return;
            }
            finally {
                this.unlockHandler();
            }
        }
    }

    public static void main(String[] args) {
        try {
            JobsAgent horseServer = new JobsAgent();
            HttpServer server = horseServer.startServer(args);
            if (server == null) {
                System.out.println("Application stopped.");
            } else {
                System.out.printf("Application started with WADL available at %sapplication.wadl%n", horseServer.getBaseUri());
                if (horseServer.openBrowser) {
                    Desktop.getDesktop().browse(horseServer.getBaseUri());
                }
                Thread.currentThread().join();
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }
}

