/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.jobs.agent.entities;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.tiogasolutions.couchace.annotations.CouchEntity;
import org.tiogasolutions.couchace.annotations.CouchId;
import org.tiogasolutions.couchace.annotations.CouchRevision;
import org.tiogasolutions.dev.common.id.uuid.TimeUuid;
import org.tiogasolutions.jobs.agent.entities.JobDefinitionEntity;
import org.tiogasolutions.jobs.pub.JobActionResult;
import org.tiogasolutions.jobs.pub.JobExecutionRequest;
import org.tiogasolutions.jobs.pub.JobParameters;

@CouchEntity(value="jobExecutionRequest")
public class JobExecutionRequestEntity {
    private final String jobExecutionRequestId;
    private final String revision;
    private final String jobDefinitionId;
    private final JobParameters jobParameters;
    private final List<JobActionResult> results = new ArrayList<JobActionResult>();

    @JsonCreator
    public JobExecutionRequestEntity(@JsonProperty(value="jobExecutionRequestId") String jobExecutionRequestId, @JsonProperty(value="revision") String revision, @JsonProperty(value="jobDefinitionId") String jobDefinitionId, @JsonProperty(value="jobExecution") JobParameters jobParameters, @JsonProperty(value="results") List<JobActionResult> results) {
        this.jobExecutionRequestId = jobExecutionRequestId;
        this.revision = revision;
        this.jobDefinitionId = jobDefinitionId;
        this.jobParameters = jobParameters;
        if (results != null) {
            this.results.addAll(results);
        }
    }

    @CouchId
    public String getJobExecutionRequestId() {
        return this.jobExecutionRequestId;
    }

    @CouchRevision
    public String getRevision() {
        return this.revision;
    }

    public JobParameters getJobParameters() {
        return this.jobParameters;
    }

    public List<JobActionResult> getResults() {
        return Collections.unmodifiableList(this.results);
    }

    public String getJobDefinitionId() {
        return this.jobDefinitionId;
    }

    public void completed(List<JobActionResult> results) {
        this.results.clear();
        this.results.addAll(results);
    }

    public JobExecutionRequest toJobExecutionRequestEntity() {
        return new JobExecutionRequest(this.jobExecutionRequestId, this.revision, this.jobDefinitionId, this.jobParameters, this.results);
    }

    public static JobExecutionRequestEntity newEntity(JobDefinitionEntity jobDefinition, JobParameters jobParameters) {
        return new JobExecutionRequestEntity(TimeUuid.randomUUID().toString(), null, jobDefinition.getJobDefinitionId(), jobParameters, Collections.emptyList());
    }
}

