/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.couchace.core.api.meta;

import org.tiogasolutions.couchace.annotations.CouchEmbeddedAttachment;
import org.tiogasolutions.couchace.core.api.http.CouchMediaType;
import org.tiogasolutions.couchace.core.api.meta.ValueAccessor;
import org.tiogasolutions.couchace.core.internal.util.StringUtil;

public class CouchEmbeddedAttachmentMeta {
    private final ValueAccessor valueAccessor;
    private final String attachmentName;
    private final CouchMediaType contentType;

    public CouchEmbeddedAttachmentMeta(CouchEmbeddedAttachment couchAttachment, ValueAccessor valueAccessor) {
        this.valueAccessor = valueAccessor;
        this.attachmentName = StringUtil.isBlank(couchAttachment.name()) ? valueAccessor.getPropertyName() : couchAttachment.name();
        this.contentType = CouchMediaType.fromString(couchAttachment.contentType());
    }

    public ValueAccessor getValueAccessor() {
        return this.valueAccessor;
    }

    public Object readValue(Object object) {
        return this.valueAccessor.readValue(object);
    }

    public void writeValue(Object object, Object value) {
        this.valueAccessor.writeValue(object, value);
    }

    public String getAttachmentName() {
        return this.attachmentName;
    }

    public CouchMediaType getContentType() {
        return this.contentType;
    }
}

