/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hk2.internal;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.WeakHashMap;
import javax.inject.Inject;
import org.glassfish.hk2.api.InjectionResolver;
import org.glassfish.hk2.utilities.reflection.Pretty;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.internal.AnnotatedElementAnnotationInfo;
import org.jvnet.hk2.internal.ServiceLocatorImpl;
import org.jvnet.hk2.internal.SoftAnnotatedElementAnnotationInfo;
import org.jvnet.hk2.internal.SystemInjecteeImpl;
import org.jvnet.hk2.internal.Utilities;

public class PerLocatorUtilities {
    private final ThreadLocal<WeakHashMap<Class<?>, String>> threadLocalAutoAnalyzerNameCache = new ThreadLocal<WeakHashMap<Class<?>, String>>(){

        @Override
        protected WeakHashMap<Class<?>, String> initialValue() {
            return new WeakHashMap();
        }
    };
    private final ThreadLocal<WeakHashMap<AnnotatedElement, SoftAnnotatedElementAnnotationInfo>> threadLocalAnnotationCache = new ThreadLocal<WeakHashMap<AnnotatedElement, SoftAnnotatedElementAnnotationInfo>>(){

        @Override
        protected WeakHashMap<AnnotatedElement, SoftAnnotatedElementAnnotationInfo> initialValue() {
            return new WeakHashMap<AnnotatedElement, SoftAnnotatedElementAnnotationInfo>();
        }
    };

    public String getAutoAnalyzerName(Class<?> c) {
        String retVal = this.threadLocalAutoAnalyzerNameCache.get().get(c);
        if (retVal != null) {
            return retVal;
        }
        Service s = c.getAnnotation(Service.class);
        if (s == null) {
            return null;
        }
        retVal = s.analyzer();
        this.threadLocalAutoAnalyzerNameCache.get().put(c, retVal);
        return retVal;
    }

    public InjectionResolver<?> getInjectionResolver(ServiceLocatorImpl locator, SystemInjecteeImpl injectee) throws IllegalStateException {
        return this.getInjectionResolver(locator, injectee.getParent(), injectee.getPosition());
    }

    InjectionResolver<?> getInjectionResolver(ServiceLocatorImpl locator, AnnotatedElement annotatedGuy) throws IllegalStateException {
        if (annotatedGuy instanceof Method || annotatedGuy instanceof Constructor) {
            throw new IllegalArgumentException("Annotated element '" + annotatedGuy + "' can be neither a Method nor a Constructor.");
        }
        return this.getInjectionResolver(locator, annotatedGuy, -1);
    }

    private InjectionResolver<?> getInjectionResolver(ServiceLocatorImpl locator, AnnotatedElement annotatedGuy, int position) throws IllegalStateException {
        boolean methodOrConstructor = annotatedGuy instanceof Method || annotatedGuy instanceof Constructor;
        Annotation injectAnnotation = this.getInjectAnnotation(locator, annotatedGuy, methodOrConstructor, position);
        Class injectType = injectAnnotation == null ? Inject.class : injectAnnotation.annotationType();
        InjectionResolver<?> retVal = locator.getInjectionResolver(injectType);
        if (retVal == null) {
            throw new IllegalStateException("There is no installed injection resolver for " + Pretty.clazz(injectType) + " for type " + annotatedGuy);
        }
        return retVal;
    }

    private Annotation getInjectAnnotation(ServiceLocatorImpl locator, AnnotatedElement annotated, boolean checkParams, int position) {
        AnnotatedElementAnnotationInfo annotationInfo = this.computeElementAnnotationInfo(annotated);
        if (checkParams && annotationInfo.hasParams) {
            for (Annotation paramAnno : annotationInfo.paramAnnotations[position]) {
                if (!locator.isInjectAnnotation(paramAnno, annotationInfo.isConstructor)) continue;
                return paramAnno;
            }
        }
        for (Annotation annotation : annotationInfo.elementAnnotations) {
            if (!locator.isInjectAnnotation(annotation)) continue;
            return annotation;
        }
        return null;
    }

    private AnnotatedElementAnnotationInfo computeElementAnnotationInfo(AnnotatedElement ae) {
        AnnotatedElementAnnotationInfo hard;
        SoftAnnotatedElementAnnotationInfo soft = this.threadLocalAnnotationCache.get().get(ae);
        if (soft != null) {
            hard = soft.harden(ae);
        } else {
            hard = Utilities.computeAEAI(ae);
            soft = hard.soften();
            this.threadLocalAnnotationCache.get().put(ae, soft);
        }
        return hard;
    }
}

