/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.jobs.agent.engine.support;

import java.io.IOException;
import javax.annotation.Priority;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.container.PreMatching;
import javax.ws.rs.ext.Provider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.tiogasolutions.jobs.kernel.config.SystemConfiguration;
import org.tiogasolutions.jobs.kernel.support.ExecutionContextManager;

@Provider
@PreMatching
@Priority(value=1000)
public class JobsResponseFilter
implements ContainerResponseFilter {
    private static final Logger log = LoggerFactory.getLogger(JobsResponseFilter.class);
    @Autowired
    private ExecutionContextManager executionManager;
    @Autowired
    private SystemConfiguration systemConfiguration;

    public JobsResponseFilter() {
        log.info("Created.");
    }

    public void filter(ContainerRequestContext requestContext, ContainerResponseContext responseContext) throws IOException {
        this.executionManager.clearContext();
        responseContext.getHeaders().add((Object)"Access-Control-Allow-Origin", (Object)this.systemConfiguration.getAccessControlAllowOrigin());
        responseContext.getHeaders().add((Object)"Access-Control-Allow-Headers", (Object)"Accept, Content-Type, Authorization");
        responseContext.getHeaders().add((Object)"Access-Control-Allow-Methods", (Object)"GET");
        responseContext.getHeaders().add((Object)"Access-Control-Allow-Credentials", (Object)"true");
    }
}

