/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.jobs.pub;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import org.tiogasolutions.jobs.pub.JobActionResult;
import org.tiogasolutions.jobs.pub.JobParameters;

public class JobExecutionRequest {
    private final String jobExecutionRequestId;
    private final String revision;
    private final String jobDefinitionId;
    private final JobParameters jobParameters;
    private final List<JobActionResult> results = new ArrayList<JobActionResult>();
    private String summary;
    private final int actionCount;
    private final ZonedDateTime createdAt;
    private ZonedDateTime updatedAt;

    @JsonCreator
    public JobExecutionRequest(@JsonProperty(value="jobExecutionRequestId") String jobExecutionRequestId, @JsonProperty(value="revision") String revision, @JsonProperty(value="jobDefinitionId") String jobDefinitionId, @JsonProperty(value="summary") String summary, @JsonProperty(value="actionCount") int actionCount, @JsonProperty(value="jobParameters") JobParameters jobParameters, @JsonProperty(value="results") List<JobActionResult> results, @JsonProperty(value="createdAt") ZonedDateTime createdAt, @JsonProperty(value="updatedAt") ZonedDateTime updatedAt) {
        this.jobExecutionRequestId = jobExecutionRequestId;
        this.revision = revision;
        this.summary = summary;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.actionCount = actionCount;
        this.jobDefinitionId = jobDefinitionId;
        this.jobParameters = jobParameters;
        if (results != null) {
            this.results.addAll(results);
        }
    }

    public String getJobExecutionRequestId() {
        return this.jobExecutionRequestId;
    }

    public String getRevision() {
        return this.revision;
    }

    public JobParameters getJobParameters() {
        return this.jobParameters;
    }

    public List<JobActionResult> getResults() {
        return this.results;
    }

    public String getJobDefinitionId() {
        return this.jobDefinitionId;
    }

    public boolean hasFailure() {
        for (JobActionResult result : this.results) {
            if (!result.hasFailure()) continue;
            return true;
        }
        return false;
    }
}

