/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.lib.spring;

import java.io.File;
import java.io.FileNotFoundException;
import java.net.MalformedURLException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import org.springframework.beans.factory.config.PropertyPlaceholderConfigurer;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.UrlResource;
import org.tiogasolutions.dev.common.EnvUtils;
import org.tiogasolutions.dev.common.ReflectUtils;

public class TiogaPropertyPlaceholderConfigurer
extends PropertyPlaceholderConfigurer {
    public TiogaPropertyPlaceholderConfigurer(String propertyName, String locationString) throws FileNotFoundException, MalformedURLException {
        ArrayList<Object> resources = new ArrayList<Object>();
        ArrayList<String> locations = new ArrayList<String>();
        Collections.addAll(locations, locationString.split(","));
        locations.add(EnvUtils.findProperty((String)propertyName, (String)""));
        for (String location : locations) {
            if ((location = location.trim()).startsWith("file:")) {
                File file = new File(URI.create(location));
                resources.add(new FileSystemResource(file));
                continue;
            }
            if (location.startsWith("classpath:")) {
                location = location.substring(10);
                resources.add(new ClassPathResource(location));
                continue;
            }
            if (location.startsWith("http:") || location.startsWith("https:")) {
                resources.add(new UrlResource(location));
                continue;
            }
            String msg = "Cannot create resource from " + location;
            throw new IllegalArgumentException(msg);
        }
        this.setLocations((Resource[])ReflectUtils.toArray(Resource.class, resources));
    }
}

