/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.jobs.agent.engine.resources;

import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.tiogasolutions.jobs.agent.engine.resources.JobsResourceV1;
import org.tiogasolutions.jobs.agent.engine.resources.RequestResourceV1;
import org.tiogasolutions.jobs.kernel.entities.JobDefinitionStore;
import org.tiogasolutions.jobs.kernel.entities.JobExecutionRequestStore;
import org.tiogasolutions.jobs.kernel.support.ExecutionContextManager;
import org.tiogasolutions.jobs.pub.DomainProfile;

public class ClientResourceV1 {
    private final JobDefinitionStore jobDefinitionStore;
    private final JobExecutionRequestStore jobExecutionRequestStore;
    private final ExecutionContextManager executionContextManager;

    public ClientResourceV1(ExecutionContextManager executionContextManager, JobExecutionRequestStore jobExecutionRequestStore, JobDefinitionStore jobDefinitionStore) {
        this.executionContextManager = executionContextManager;
        this.jobDefinitionStore = jobDefinitionStore;
        this.jobExecutionRequestStore = jobExecutionRequestStore;
    }

    @GET
    @Produces(value={"application/json"})
    public DomainProfile getDomainProfile() {
        return this.executionContextManager.getExecutionContext().getDomainProfileEntity().toDomainProfile();
    }

    @GET
    @Path(value="sign-in")
    @Produces(value={"application/json"})
    public DomainProfile signIn() {
        return this.getDomainProfile();
    }

    @Path(value="/jobs")
    public JobsResourceV1 getJobsResourceV1() {
        return new JobsResourceV1(this.jobExecutionRequestStore, this.jobDefinitionStore);
    }

    @Path(value="/requests")
    public RequestResourceV1 getRequestResourceV1() {
        return new RequestResourceV1(this.jobExecutionRequestStore);
    }
}

