/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.couchace.core.api.meta;

import java.util.HashMap;
import java.util.Map;
import org.tiogasolutions.couchace.core.api.meta.AnnotationCouchMetaBuilder;
import org.tiogasolutions.couchace.core.api.meta.CouchEntityMeta;
import org.tiogasolutions.couchace.core.api.meta.CouchMetaBuilder;

public class CouchMetaRepository {
    private final Map<String, CouchEntityMeta<?>> entityMetaMap = new HashMap();
    private final CouchMetaBuilder metaBuilder;

    public CouchMetaRepository(CouchMetaBuilder metaBuilder) {
        this.metaBuilder = metaBuilder;
    }

    public CouchMetaRepository() {
        this.metaBuilder = new AnnotationCouchMetaBuilder();
    }

    public <T> CouchEntityMeta<T> getEntityMeta(Class<T> type) {
        String name = type.getName();
        return this.entityMetaMap.get(name);
    }

    public <T> CouchEntityMeta<T> getOrCreateEntityMeta(Class<T> type) {
        CouchEntityMeta<T> entityMeta = this.getEntityMeta(type);
        if (entityMeta == null) {
            entityMeta = this.createEntityMeta(type);
            this.putEntityMeta(entityMeta);
        }
        return entityMeta;
    }

    public void putEntityMeta(CouchEntityMeta entityMeta) {
        this.entityMetaMap.put(entityMeta.getMetaName(), entityMeta);
    }

    public CouchEntityMeta removeEntityMeta(String metaName) {
        return this.entityMetaMap.remove(metaName);
    }

    protected <T> CouchEntityMeta<T> createEntityMeta(Class<T> type) {
        return this.metaBuilder.buildEntityMeta(type);
    }

    protected Map<String, CouchEntityMeta<?>> getEntityMetaMap() {
        return this.entityMetaMap;
    }
}

