/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.jobs.agent.engine.actions;

import java.io.File;
import java.io.FileNotFoundException;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.tiogasolutions.dev.common.IoUtils;
import org.tiogasolutions.dev.common.ReflectUtils;
import org.tiogasolutions.jobs.agent.engine.actions.JobActionExecutorSupport;
import org.tiogasolutions.jobs.kernel.entities.JobExecutionRequestEntity;
import org.tiogasolutions.jobs.pub.JobAction;
import org.tiogasolutions.jobs.pub.JobActionResult;
import org.tiogasolutions.jobs.pub.actions.OsAction;

public class OsActionExecutor
extends JobActionExecutorSupport {
    private static final Log log = LogFactory.getLog(OsActionExecutor.class);

    @Override
    public JobActionResult execute(JobExecutionRequestEntity request, JobAction jobAction, ZonedDateTime startedAt) throws Exception {
        JobActionResult result;
        if (!(jobAction instanceof OsAction)) {
            String msg = String.format("The action %s cannot be processed by %s", jobAction.getClass().getName(), this.getClass().getName());
            throw new UnsupportedOperationException(msg);
        }
        OsAction action = (OsAction)jobAction;
        String command = action.getCommand();
        command = super.substitute(request, command);
        String out = null;
        String err = null;
        try {
            List<String> commands = OsActionExecutor.splitCommand(command);
            String[] commandArray = (String[])ReflectUtils.toArray(String.class, commands);
            File workingDir = action.getWorkingDirectory();
            if (!workingDir.exists()) {
                String msg = "The specified working directory does not exist: " + workingDir.getAbsolutePath();
                throw new FileNotFoundException(msg);
            }
            File outFile = File.createTempFile("process-out-", ".txt");
            outFile.deleteOnExit();
            File errFile = File.createTempFile("process-err-", ".txt");
            errFile.deleteOnExit();
            Process process = new ProcessBuilder(new String[0]).command(commandArray).directory(workingDir).redirectOutput(ProcessBuilder.Redirect.to(outFile)).redirectError(ProcessBuilder.Redirect.to(errFile)).start();
            process.waitFor(action.getTimeout(), action.getTimeoutUnit());
            if (process.isAlive()) {
                process.destroyForcibly();
            }
            int exitValue = process.exitValue();
            out = IoUtils.toString((File)outFile);
            if (!outFile.delete()) {
                log.warn((Object)("Unable to delete temp file: " + outFile.getAbsolutePath()));
            }
            err = IoUtils.toString((File)errFile);
            if (!errFile.delete()) {
                log.warn((Object)("Unable to delete temp file: " + errFile.getAbsolutePath()));
            }
            result = JobActionResult.finished((String)command, (ZonedDateTime)startedAt, (int)exitValue, (String)out, (String)err);
        }
        catch (IllegalThreadStateException e) {
            result = JobActionResult.timeoutFailure((String)command, (ZonedDateTime)startedAt);
        }
        catch (Exception ex) {
            result = JobActionResult.fail((String)command, (ZonedDateTime)startedAt, (Exception)ex, out, err);
        }
        return result;
    }

    protected static List<String> splitCommand(String command) {
        boolean inString = false;
        ArrayList<String> commands = new ArrayList<String>();
        StringBuilder builder = new StringBuilder();
        for (char chr : command.toCharArray()) {
            if (inString) {
                if (chr != '\"') {
                    builder.append(chr);
                    continue;
                }
                inString = false;
                OsActionExecutor.finish(builder, commands);
                continue;
            }
            if (chr == '\"') {
                inString = true;
                continue;
            }
            if (Character.isWhitespace(chr)) {
                OsActionExecutor.finish(builder, commands);
                continue;
            }
            builder.append(chr);
        }
        OsActionExecutor.finish(builder, commands);
        return commands;
    }

    private static void finish(StringBuilder builder, List<String> commands) {
        if (builder.length() > 0) {
            commands.add(builder.toString());
        }
        builder.delete(0, builder.length());
    }
}

