/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.jobs.agent.engine.resources;

import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Application;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.tiogasolutions.dev.common.exceptions.ApiException;
import org.tiogasolutions.dev.common.exceptions.ApiNotFoundException;
import org.tiogasolutions.dev.domain.query.ListQueryResult;
import org.tiogasolutions.dev.domain.query.QueryResult;
import org.tiogasolutions.jobs.agent.engine.actions.InternalActionExecutor;
import org.tiogasolutions.jobs.agent.engine.actions.JobActionExecutor;
import org.tiogasolutions.jobs.agent.engine.actions.OsActionExecutor;
import org.tiogasolutions.jobs.kernel.entities.JobDefinitionEntity;
import org.tiogasolutions.jobs.kernel.entities.JobDefinitionStore;
import org.tiogasolutions.jobs.kernel.entities.JobExecutionRequestEntity;
import org.tiogasolutions.jobs.kernel.entities.JobExecutionRequestStore;
import org.tiogasolutions.jobs.pub.ActionType;
import org.tiogasolutions.jobs.pub.JobAction;
import org.tiogasolutions.jobs.pub.JobActionResult;
import org.tiogasolutions.jobs.pub.JobDefinition;
import org.tiogasolutions.jobs.pub.JobExecutionRequest;
import org.tiogasolutions.jobs.pub.JobParameters;

public class JobsResourceV1 {
    private static final Log log = LogFactory.getLog(JobsResourceV1.class);
    private static final ExecutorService executor = Executors.newCachedThreadPool();
    private final JobDefinitionStore jobDefinitionStore;
    private final JobExecutionRequestStore jobExecutionRequestStore;
    private final Map<ActionType, JobActionExecutor> executors = new HashMap<ActionType, JobActionExecutor>();

    public JobsResourceV1(JobExecutionRequestStore jobExecutionRequestStore, JobDefinitionStore jobDefinitionStore) {
        this.jobDefinitionStore = jobDefinitionStore;
        this.jobExecutionRequestStore = jobExecutionRequestStore;
        this.executors.put(ActionType.OS_COMMAND, new OsActionExecutor());
        InternalActionExecutor internalExecutor = new InternalActionExecutor();
        this.executors.put(ActionType.WAIT_FOR_HTTP, internalExecutor);
    }

    @GET
    @Produces(value={"application/json"})
    public QueryResult<JobDefinition> getJobs(@Context Application app) {
        ArrayList jobDefinitions = new ArrayList();
        this.jobDefinitionStore.getAll().stream().forEach(jobEntity -> jobDefinitions.add(jobEntity.toJobDefinition()));
        return ListQueryResult.newComplete(JobDefinition.class, jobDefinitions);
    }

    private JobDefinitionEntity loadJob(Application app, String jobDefinitionId) {
        JobDefinitionEntity jobDefinitionEntity = (JobDefinitionEntity)this.jobDefinitionStore.getByDocumentId(jobDefinitionId);
        if (jobDefinitionEntity == null) {
            String msg = String.format("The job definition \"%s\" does not exist.", jobDefinitionId);
            throw ApiNotFoundException.notFound((String)msg, (String[])new String[0]);
        }
        return jobDefinitionEntity;
    }

    @GET
    @Path(value="/{jobDefinitionId}")
    @Produces(value={"application/json"})
    public JobDefinition getJob(@Context Application app, @PathParam(value="jobDefinitionId") String jobDefinitionId) throws Exception {
        return this.loadJob(app, jobDefinitionId).toJobDefinition();
    }

    @POST
    @Path(value="/{jobDefinitionId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response execute(@Context Application app, @Context UriInfo uriInfo, @PathParam(value="jobDefinitionId") String jobDefinitionId, JobParameters jobParameters) throws Exception {
        JobExecutionRequest request;
        if (jobParameters == null) {
            throw ApiException.badRequest((String)"The job parameters must be specified.", (String[])new String[0]);
        }
        JobDefinitionEntity jobDefinitionEntity = this.loadJob(app, jobDefinitionId);
        JobExecutionRequestEntity requestEntity = JobExecutionRequestEntity.newEntity((JobDefinitionEntity)jobDefinitionEntity, (JobParameters)jobParameters);
        this.jobExecutionRequestStore.create((Object)requestEntity);
        if (jobParameters.isSynchronous()) {
            request = this.executeJob(app, requestEntity, jobDefinitionEntity);
        } else {
            executor.submit(() -> this.executeJob(app, requestEntity, jobDefinitionEntity));
            request = requestEntity.toJobExecutionRequest();
        }
        if (requestEntity.hasFailure()) {
            return Response.status((int)500).entity((Object)request).build();
        }
        if (jobParameters.isSynchronous()) {
            return Response.status((int)200).entity((Object)request).build();
        }
        return Response.status((int)202).entity((Object)request).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JobExecutionRequest executeJob(Application app, JobExecutionRequestEntity request, JobDefinitionEntity jobDefinitionEntity) throws Exception {
        for (JobAction action : jobDefinitionEntity.getJobActions()) {
            JobActionResult result;
            if (action.getLock() == null) {
                result = this.processAction(app, request, action);
            } else {
                log.info((Object)String.format("Locking action %s for request %s", action.getLabel(), request.getJobExecutionRequestId()));
                String string = action.getLock().intern();
                synchronized (string) {
                    result = this.processAction(app, request, action);
                }
            }
            if (!result.hasFailure()) continue;
            break;
        }
        this.jobExecutionRequestStore.update((Object)request);
        return request.toJobExecutionRequest();
    }

    private JobActionResult processAction(Application app, JobExecutionRequestEntity request, JobAction action) throws Exception {
        JobActionResult result;
        log.info((Object)String.format("Executing action %s for request %s", action.getLabel(), request.getJobExecutionRequestId()));
        ActionType actionType = action.getActionType();
        JobActionExecutor executor = this.executors.get(actionType);
        if (executor == null) {
            String msg = String.format("The action type \"%s\" is not supported.", actionType);
            throw new UnsupportedOperationException(msg);
        }
        ZonedDateTime startedAt = ZonedDateTime.now();
        try {
            result = executor.execute(request, action, startedAt);
        }
        catch (Exception ex) {
            log.error((Object)"Unhandled exception while processing action", (Throwable)ex);
            result = JobActionResult.fail((String)action.getLabel(), (ZonedDateTime)startedAt, (Exception)ex, null, null);
        }
        request.addResult(result);
        this.jobExecutionRequestStore.update((Object)request);
        return result;
    }
}

