/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.jobs.agent.grizzly;

import ch.qos.logback.classic.Level;
import java.nio.file.Path;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.support.AbstractXmlApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.context.support.FileSystemXmlApplicationContext;
import org.tiogasolutions.app.common.AppPathResolver;
import org.tiogasolutions.app.common.AppUtils;
import org.tiogasolutions.runners.grizzly.GrizzlyServer;
import org.tiogasolutions.runners.grizzly.GrizzlyServerConfig;
import org.tiogasolutions.runners.grizzly.ShutdownUtils;

public class JobsAgentServer {
    private static final Logger log = LoggerFactory.getLogger(JobsAgentServer.class);

    public static void main(String ... args) throws Exception {
        AppUtils.initLogback((Level)Level.WARN);
        AppUtils.setLogLevel((Level)Level.INFO, (Class[])new Class[]{JobsAgentServer.class});
        AppUtils.setLogLevel((Level)Level.INFO, (Class[])new Class[]{GrizzlyServer.class});
        AppPathResolver resolver = new AppPathResolver("jobs-agent.");
        Path runtimeDir = resolver.resolveRuntimePath();
        Path configDir = resolver.resolveConfigDir(runtimeDir);
        Path logbackFile = AppUtils.initLogback((Path)configDir, (String)"jobs.log.config", (String)"logback.xml");
        String springConfigPath = resolver.resolveSpringPath(configDir, null);
        String[] activeProfiles = resolver.resolveSpringProfiles();
        boolean shuttingDown = Arrays.asList(args).contains("-shutdown");
        String action = shuttingDown ? "Shutting down" : "Starting";
        log.info("{} server:\n  *  Runtime Dir     (jobs.runtime.dir)     {}\n  *  Config Dir      (jobs.config.dir)      {}\n  *  Logback File    (jobs.log.config)      {}\n  *  Spring Path     (jobs.spring.config)   {}\n  *  Active Profiles (jobs.active.profiles) {}", new Object[]{action, runtimeDir, configDir, logbackFile, springConfigPath, Arrays.asList(activeProfiles)});
        AbstractXmlApplicationContext applicationContext = JobsAgentServer.createXmlConfigApplicationContext(springConfigPath, activeProfiles);
        GrizzlyServer grizzlyServer = (GrizzlyServer)applicationContext.getBean(GrizzlyServer.class);
        if (Arrays.asList(args).contains("-shutdown")) {
            ShutdownUtils.shutdownRemote((GrizzlyServerConfig)grizzlyServer.getConfig());
            log.warn("Shutting down server at {}:{}", (Object)grizzlyServer.getConfig().getHostName(), (Object)grizzlyServer.getConfig().getShutdownPort());
            System.exit(0);
            return;
        }
        grizzlyServer.start();
    }

    public static AbstractXmlApplicationContext createXmlConfigApplicationContext(String xmlConfigPath, String ... activeProfiles) {
        boolean classPath = xmlConfigPath.startsWith("classpath:");
        ClassPathXmlApplicationContext applicationContext = classPath ? new ClassPathXmlApplicationContext() : new FileSystemXmlApplicationContext();
        applicationContext.setConfigLocation(xmlConfigPath);
        applicationContext.getEnvironment().setActiveProfiles(activeProfiles);
        applicationContext.refresh();
        return applicationContext;
    }
}

