/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.dev.common.exceptions;

import org.tiogasolutions.dev.common.exceptions.ApiException;
import org.tiogasolutions.dev.common.fine.FineMessage;
import org.tiogasolutions.dev.common.fine.FineMessageSet;
import org.tiogasolutions.dev.common.net.HttpStatusCode;

public class Api4xxException
extends ApiException {
    private static final long serialVersionUID = 1L;

    Api4xxException(HttpStatusCode httpStatusCode) {
        super(Api4xxException.assert400(httpStatusCode));
    }

    Api4xxException(HttpStatusCode httpStatusCode, String message, String ... traits) {
        super(Api4xxException.assert400(httpStatusCode), message, traits);
    }

    Api4xxException(HttpStatusCode httpStatusCode, Throwable ex, String ... traits) {
        super(Api4xxException.assert400(httpStatusCode), ex, traits);
    }

    Api4xxException(HttpStatusCode httpStatusCode, String message, Throwable ex, String ... traits) {
        super(Api4xxException.assert400(httpStatusCode), message, ex, traits);
    }

    Api4xxException(HttpStatusCode httpStatusCode, FineMessage richMessage) {
        super(Api4xxException.assert400(httpStatusCode), richMessage);
    }

    Api4xxException(HttpStatusCode httpStatusCode, FineMessage richMessage, Throwable ex) {
        super(Api4xxException.assert400(httpStatusCode), richMessage, ex);
    }

    Api4xxException(HttpStatusCode httpStatusCode, FineMessageSet messageSet) {
        super(Api4xxException.assert400(httpStatusCode), messageSet);
    }

    Api4xxException(HttpStatusCode httpStatusCode, FineMessageSet messageSet, Throwable ex) {
        super(Api4xxException.assert400(httpStatusCode), messageSet, ex);
    }

    private static HttpStatusCode assert400(HttpStatusCode httpStatusCode) {
        int code = httpStatusCode.getCode();
        if (code < 400 || code > 499) {
            String msg = String.format("The HTTP status code (%s) must between 400 & 499 inclusive.", code);
            throw new IllegalArgumentException(msg);
        }
        return httpStatusCode;
    }
}

