/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.jobs.kernel.entities;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.tiogasolutions.couchace.annotations.CouchEntity;
import org.tiogasolutions.couchace.annotations.CouchId;
import org.tiogasolutions.couchace.annotations.CouchRevision;
import org.tiogasolutions.dev.common.id.uuid.TimeUuid;
import org.tiogasolutions.jobs.pub.JobAction;
import org.tiogasolutions.jobs.pub.JobDefinition;

@CouchEntity(value="jobDefinition")
public class JobDefinitionEntity {
    private final String jobDefinitionId;
    private final String revision;
    private final List<JobAction> jobActions = new ArrayList<JobAction>();

    @JsonCreator
    public JobDefinitionEntity(@JsonProperty(value="jobDefinitionId") String jobDefinitionId, @JsonProperty(value="revision") String revision, @JsonProperty(value="actions") Collection<? extends JobAction> actions) {
        this.jobDefinitionId = jobDefinitionId;
        this.revision = revision;
        if (actions != null) {
            this.jobActions.addAll(actions);
        }
    }

    @CouchId
    public String getJobDefinitionId() {
        return this.jobDefinitionId;
    }

    @CouchRevision
    public String getRevision() {
        return this.revision;
    }

    public List<JobAction> getJobActions() {
        return this.jobActions;
    }

    public JobDefinition toJobDefinition() {
        return new JobDefinition(this.jobDefinitionId, this.revision, this.jobActions);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JobDefinitionEntity jobDefinitionEntity = (JobDefinitionEntity)o;
        if (!this.jobDefinitionId.equals(jobDefinitionEntity.jobDefinitionId)) {
            return false;
        }
        return this.getClass().equals(jobDefinitionEntity.getClass());
    }

    public int hashCode() {
        int result = this.jobDefinitionId.hashCode();
        result = 31 * result + this.getClass().hashCode();
        return result;
    }

    public static JobDefinitionEntity newEntity(JobAction ... jobActions) {
        return JobDefinitionEntity.newJobDefinition(TimeUuid.randomUUID().toString(), Arrays.asList(jobActions));
    }

    public static JobDefinitionEntity newEntity(Collection<? extends JobAction> jobActions) {
        return JobDefinitionEntity.newJobDefinition(TimeUuid.randomUUID().toString(), jobActions);
    }

    public static JobDefinitionEntity newJobDefinition(String id, Collection<? extends JobAction> actions) {
        return new JobDefinitionEntity(id, null, actions);
    }
}

