/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.lib.jaxrs.providers;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;
import org.tiogasolutions.dev.common.IoUtils;
import org.tiogasolutions.dev.jackson.TiogaJacksonObjectMapper;

public abstract class TiogaReaderWriterProvider<T>
implements MessageBodyReader<T>,
MessageBodyWriter<T> {
    private final ObjectMapper objectMapper;

    public TiogaReaderWriterProvider() {
        this.objectMapper = new TiogaJacksonObjectMapper();
    }

    public TiogaReaderWriterProvider(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public long getSize(T t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    public T readFrom(Class<T> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> map, InputStream stream) throws IOException, WebApplicationException {
        String json = IoUtils.toString((InputStream)stream);
        return (T)this.objectMapper.readValue(json, type);
    }

    public void writeTo(T value, Class<?> aClass, Type type, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> map, OutputStream stream) throws IOException, WebApplicationException {
        String json = this.objectMapper.writeValueAsString(value);
        stream.write(json.getBytes());
    }

    public final boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return true;
    }

    public final boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return true;
    }
}

