/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.jobs.jackson;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.DatabindContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.jsontype.TypeIdResolver;
import com.fasterxml.jackson.databind.type.TypeFactory;
import org.tiogasolutions.jobs.pub.ActionType;
import org.tiogasolutions.jobs.pub.JobAction;

public class JobActionJacksonResolver
implements TypeIdResolver {
    public void init(JavaType baseType) {
    }

    public String idFromValue(Object value) {
        JobAction action = (JobAction)value;
        return action.getActionType().name();
    }

    public String idFromValueAndType(Object value, Class<?> suggestedType) {
        JobAction action = (JobAction)value;
        return action.getActionType().name();
    }

    public String idFromBaseType() {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public JavaType typeFromId(String id) {
        return this.typeFromId(null, id);
    }

    public JavaType typeFromId(DatabindContext context, String id) {
        ActionType actionType = ActionType.valueOf((String)id);
        try {
            Class<?> type = Class.forName(actionType.getTypeName());
            return TypeFactory.defaultInstance().uncheckedSimpleType(type);
        }
        catch (ClassNotFoundException e) {
            String msg = String.format("The action type %s's implementing type %s was not found", actionType, actionType.getTypeName());
            throw new UnsupportedOperationException(msg);
        }
    }

    public JsonTypeInfo.Id getMechanism() {
        return JsonTypeInfo.Id.CUSTOM;
    }
}

