/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.jobs.agent.engine.actions;

import java.io.UnsupportedEncodingException;
import java.time.Duration;
import java.time.ZonedDateTime;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.xml.bind.DatatypeConverter;
import org.tiogasolutions.dev.common.StringUtils;
import org.tiogasolutions.jobs.agent.engine.actions.JobActionExecutorSupport;
import org.tiogasolutions.jobs.kernel.entities.JobExecutionRequestEntity;
import org.tiogasolutions.jobs.pub.JobAction;
import org.tiogasolutions.jobs.pub.JobActionResult;
import org.tiogasolutions.jobs.pub.actions.WaitForHttpAction;

public class InternalActionExecutor
extends JobActionExecutorSupport {
    @Override
    public JobActionResult execute(JobExecutionRequestEntity request, JobAction jobAction, ZonedDateTime startedAt) throws Exception {
        if (jobAction instanceof WaitForHttpAction) {
            return this.executeWaitForHttpAction(request, (WaitForHttpAction)jobAction, startedAt);
        }
        String msg = String.format("The action %s cannot be processed by %s", jobAction.getClass().getName(), this.getClass().getName());
        throw new UnsupportedOperationException(msg);
    }

    private JobActionResult executeWaitForHttpAction(JobExecutionRequestEntity request, WaitForHttpAction action, ZonedDateTime startedAt) throws Exception {
        String httpRequest = action.getHttpRequest();
        httpRequest = super.substitute(request, httpRequest);
        long elapsed = Duration.between(startedAt, ZonedDateTime.now()).toMillis();
        long timeout = TimeUnit.MILLISECONDS.convert(action.getTimeout(), action.getTimeoutUnit());
        String err = "";
        String body = null;
        String command = String.format("Wait for %s", httpRequest);
        if (action.getRegex() != null) {
            command = command + String.format(", match \"%s\"", action.getRegex());
        }
        while (elapsed < timeout) {
            Response response = InternalActionExecutor.get(action, httpRequest);
            body = (String)response.readEntity(String.class);
            if (!action.getStatuses().contains(response.getStatus())) {
                err = err + String.format("Invalid status code %s\n", response.getStatus());
            } else {
                if (action.getRegex() == null) {
                    return JobActionResult.finished((String)command, (ZonedDateTime)startedAt, (String)body);
                }
                Pattern pattern = Pattern.compile(action.getRegex());
                Matcher matcher = pattern.matcher(body);
                if (matcher.find()) {
                    String text = matcher.group(0);
                    return JobActionResult.finished((String)command, (ZonedDateTime)startedAt, (String)text);
                }
                err = err + "Regular expression match failed\n";
            }
            Thread.sleep(1000L);
            elapsed = Duration.between(startedAt, ZonedDateTime.now()).toMillis();
        }
        err = StringUtils.whiteSpaceToNull((Object)err);
        return JobActionResult.timeoutFailure((String)command, (ZonedDateTime)startedAt, body, (String)err);
    }

    public static Response get(WaitForHttpAction action, String httpRequest) {
        Client client = ClientBuilder.newBuilder().build();
        UriBuilder uriBuilder = UriBuilder.fromUri((String)httpRequest);
        WebTarget target = client.target(uriBuilder);
        Invocation.Builder builder = target.request(action.getAcceptedResponseTypes());
        if (StringUtils.isNotBlank((Object)action.getUsername())) {
            builder.header("Authorization", (Object)InternalActionExecutor.getBasicAuthentication(action.getUsername(), action.getPassword()));
        }
        return (Response)builder.get(Response.class);
    }

    private static String getBasicAuthentication(String username, String password) {
        try {
            String token = username + ":" + password;
            return "Basic " + DatatypeConverter.printBase64Binary((byte[])token.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException ex) {
            throw new IllegalStateException("Cannot encode with UTF-8", ex);
        }
    }
}

