/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.couchace.core.api.response;

import java.net.URI;
import org.tiogasolutions.couchace.core.api.http.CouchHttpStatus;
import org.tiogasolutions.couchace.core.api.http.CouchMediaType;
import org.tiogasolutions.couchace.core.api.http.CouchMethodType;
import org.tiogasolutions.couchace.core.api.response.CouchErrorContent;
import org.tiogasolutions.couchace.core.api.response.CouchResponse;
import org.tiogasolutions.couchace.core.internal.util.ArgUtil;

public abstract class GetResponse
implements CouchResponse {
    private final URI uri;
    private final CouchHttpStatus httpStatus;
    private final CouchMediaType contentType;
    private final CouchErrorContent errorContent;

    protected GetResponse(URI uri, CouchHttpStatus httpStatus, CouchMediaType contentType, CouchErrorContent errorContent) {
        ArgUtil.assertNotNull(uri, "URI");
        this.uri = uri;
        this.httpStatus = httpStatus != null ? httpStatus : CouchHttpStatus.OK;
        this.contentType = contentType != null ? contentType : CouchMediaType.APPLICATION_JSON;
        this.errorContent = errorContent != null ? errorContent : CouchErrorContent.noError;
    }

    @Override
    public URI getUri() {
        return this.uri;
    }

    @Override
    public boolean isSuccess() {
        return this.httpStatus == CouchHttpStatus.CREATED || this.httpStatus == CouchHttpStatus.OK;
    }

    @Override
    public boolean isConflict() {
        return this.httpStatus.isConflict();
    }

    @Override
    public boolean isError() {
        return this.httpStatus != CouchHttpStatus.CREATED && this.httpStatus != CouchHttpStatus.OK;
    }

    @Override
    public boolean isCreated() {
        return this.httpStatus.isCreated();
    }

    @Override
    public boolean isOk() {
        return this.httpStatus.isOk();
    }

    @Override
    public boolean isUnauthorized() {
        return this.httpStatus.isUnauthorized();
    }

    @Override
    public boolean isNotFound() {
        return this.httpStatus.isNotFound();
    }

    @Override
    public CouchMediaType getContentType() {
        return this.contentType;
    }

    @Override
    public CouchMethodType getMethodType() {
        return CouchMethodType.GET;
    }

    @Override
    public CouchHttpStatus getHttpStatus() {
        return this.httpStatus;
    }

    @Override
    public int getHttpStatusCode() {
        return this.httpStatus.getCode();
    }

    @Override
    public CouchErrorContent getErrorContent() {
        return this.errorContent;
    }

    @Override
    public String getErrorReason() {
        return this.errorContent.getReason();
    }
}

