/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.runners.grizzly.spring;

import org.glassfish.jersey.server.spring.scope.RequestContextFilter;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;
import org.springframework.context.support.AbstractXmlApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.context.support.FileSystemXmlApplicationContext;
import org.tiogasolutions.runners.grizzly.GrizzlyServerConfig;
import org.tiogasolutions.runners.grizzly.GrizzlyServerSupport;
import org.tiogasolutions.runners.grizzly.ShutdownHandler;
import org.tiogasolutions.runners.grizzly.spring.ApplicationResolver;
import org.tiogasolutions.runners.grizzly.spring.ServerConfigResolver;

public class GrizzlySpringServer
extends GrizzlyServerSupport {
    public static final Class<?>[] GRIZZLY_CLASSES = new Class[]{GrizzlySpringServer.class, GrizzlyServerConfig.class, GrizzlyServerSupport.class, ShutdownHandler.class};
    private final ApplicationContext applicationContext;

    public GrizzlySpringServer(ServerConfigResolver serverConfigResolver, ApplicationResolver applicationResolver, String activeProfiles, Class<?> ... annotatedClasses) {
        this(serverConfigResolver, applicationResolver, (ApplicationContext)GrizzlySpringServer.createAnnotationConfigApplicationContext(activeProfiles, annotatedClasses));
    }

    public GrizzlySpringServer(ServerConfigResolver serverConfigResolver, ApplicationResolver applicationResolver, String activeProfiles, String xmlConfigPath) {
        this(serverConfigResolver, applicationResolver, (ApplicationContext)GrizzlySpringServer.createXmlConfigApplicationContext(activeProfiles, xmlConfigPath));
    }

    public GrizzlySpringServer(ServerConfigResolver serverConfigResolver, ApplicationResolver applicationResolver, ApplicationContext applicationContext) {
        super(serverConfigResolver.getConfig((BeanFactory)applicationContext), applicationResolver.getApplication((BeanFactory)applicationContext));
        this.applicationContext = applicationContext;
        this.resourceConfig.register(RequestContextFilter.class);
        this.resourceConfig.property("contextConfig", (Object)applicationContext);
    }

    public static AnnotationConfigApplicationContext createAnnotationConfigApplicationContext(String activeProfiles, Class<?>[] annotatedClasses) {
        AnnotationConfigApplicationContext applicationContext = new AnnotationConfigApplicationContext();
        applicationContext.getEnvironment().setActiveProfiles(GrizzlySpringServer.split(activeProfiles));
        applicationContext.register((Class[])annotatedClasses);
        applicationContext.refresh();
        return applicationContext;
    }

    public static AbstractXmlApplicationContext createXmlConfigApplicationContext(String activeProfiles, String xmlConfigPath) {
        Object applicationContext = xmlConfigPath.startsWith("classpath:") ? new ClassPathXmlApplicationContext() : new FileSystemXmlApplicationContext();
        applicationContext.setConfigLocation(xmlConfigPath);
        applicationContext.getEnvironment().setActiveProfiles(GrizzlySpringServer.split(activeProfiles));
        applicationContext.refresh();
        return applicationContext;
    }

    private static String[] split(String activeProfiles) {
        String[] values = activeProfiles == null ? new String[]{} : activeProfiles.split(",");
        for (int i = 0; i < values.length; ++i) {
            values[i] = values[i].trim();
        }
        return values;
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }
}

