/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.runners.grizzly;

import java.awt.Desktop;
import java.io.IOException;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.Socket;
import java.net.URI;
import javax.ws.rs.core.Application;
import org.glassfish.grizzly.http.server.HttpServer;
import org.glassfish.jersey.grizzly2.httpserver.GrizzlyHttpServerFactory;
import org.glassfish.jersey.server.ResourceConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tiogasolutions.runners.grizzly.GrizzlyServerConfig;
import org.tiogasolutions.runners.grizzly.ShutdownHandler;

public abstract class GrizzlyServerSupport {
    private static final Logger log = LoggerFactory.getLogger(GrizzlyServerSupport.class);
    protected HttpServer httpServer;
    protected final ResourceConfig resourceConfig;
    protected final GrizzlyServerConfig serverConfig;

    public GrizzlyServerSupport(GrizzlyServerConfig serverConfig, Application application) {
        this.serverConfig = serverConfig;
        this.resourceConfig = ResourceConfig.forApplication((Application)application);
    }

    public ResourceConfig getResourceConfig() {
        return this.resourceConfig;
    }

    public URI getBaseUri() {
        return this.serverConfig.getBaseUri();
    }

    public GrizzlyServerConfig getConfig() {
        return this.serverConfig;
    }

    public void start() {
        try {
            GrizzlyServerSupport.shutdownRemote(this.serverConfig);
            this.httpServer = GrizzlyHttpServerFactory.createHttpServer((URI)this.serverConfig.getBaseUri(), (ResourceConfig)this.resourceConfig);
            log.info("Application started at {}", (Object)this.getBaseUri());
            log.info("WADL available at {}application.wadl", (Object)this.getBaseUri());
            this.createShutdownHandler().start(this.httpServer);
            if (this.serverConfig.isToOpenBrowser()) {
                log.info("Opening web browser to {}", (Object)this.getBaseUri());
                URI baseUri = this.getBaseUri();
                Desktop.getDesktop().browse(baseUri);
            }
            Thread.currentThread().join();
        }
        catch (Throwable e) {
            log.error("Exception starting server", e);
            e.printStackTrace();
        }
    }

    protected ShutdownHandler createShutdownHandler() {
        return new ShutdownHandler(this.serverConfig);
    }

    public void shutdownThis() {
        if (this.httpServer != null) {
            this.httpServer.shutdown();
        }
    }

    public static void shutdownRemote(GrizzlyServerConfig config) throws IOException {
        try (Socket localSocket = new Socket(config.getHostName(), config.getShutdownPort());
             OutputStream outStream = localSocket.getOutputStream();){
            outStream.write("SHUTDOWN".getBytes());
            outStream.flush();
        }
        catch (ConnectException connectException) {
            // empty catch block
        }
    }

    public void register(Class type) {
        this.resourceConfig.register(type);
    }

    public void packages(String ... packages) {
        this.resourceConfig.packages(packages);
    }
}

