/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.jobs.agent.core;

import java.util.Arrays;
import javax.inject.Inject;
import javax.inject.Named;
import javax.xml.bind.DatatypeConverter;
import org.springframework.context.annotation.Profile;
import org.tiogasolutions.couchace.core.api.CouchDatabase;
import org.tiogasolutions.couchace.core.api.request.CouchFeature;
import org.tiogasolutions.couchace.core.api.request.CouchFeatureSet;
import org.tiogasolutions.jobs.kernel.entities.CouchServersConfig;
import org.tiogasolutions.lib.couchace.DefaultCouchServer;

@Named
@Profile(value={"test"})
public class TestFactory {
    public static final String API_KEY = "9999";
    public static final String API_PASSWORD = "unittest";

    @Inject
    public TestFactory(CouchServersConfig domainDbConfig) throws Exception {
        String sysDatabase = "test-jobs";
        String usrDatabase = domainDbConfig.getDomainDatabasePrefix() + "testing" + domainDbConfig.getDomainDatabaseSuffix();
        DefaultCouchServer server = new DefaultCouchServer();
        for (String dbName : Arrays.asList(sysDatabase, usrDatabase)) {
            CouchDatabase database = server.database(dbName, CouchFeatureSet.builder().add(CouchFeature.ALLOW_DB_DELETE, (Object)true).build());
            if (!database.exists()) continue;
            database.deleteDatabase();
        }
    }

    public String toHttpAuth(String username, String password) {
        byte[] value = (username + ":" + password).getBytes();
        return "Basic " + DatatypeConverter.printBase64Binary((byte[])value);
    }
}

