/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.lib.spring.jersey;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.glassfish.hk2.api.Factory;
import org.glassfish.hk2.utilities.binding.AbstractBinder;
import org.springframework.beans.factory.ListableBeanFactory;

public class JerseySpringBridge
extends AbstractBinder {
    private final List<Object> nonSpringObjects = new ArrayList<Object>();
    private final ListableBeanFactory beanFactory;

    public JerseySpringBridge(ListableBeanFactory beanFactory, Object ... nonSpringObjects) {
        this.beanFactory = beanFactory;
        Collections.addAll(this.nonSpringObjects, nonSpringObjects);
    }

    protected void configure() {
        String[] beanNames;
        for (final Object object : this.nonSpringObjects) {
            this.bindFactory((Factory)new Factory<Object>(){

                public void dispose(Object instance) {
                }

                public Object provide() {
                    return object;
                }
            }).to(object.getClass());
        }
        for (String beanName : beanNames = this.beanFactory.getBeanDefinitionNames()) {
            final Object bean = this.beanFactory.getBean(beanName);
            List<Class<?>> types = this.getAllTypes(bean);
            for (Class<?> type : types) {
                this.bindFactory((Factory)new Factory<Object>(){

                    public void dispose(Object instance) {
                    }

                    public Object provide() {
                        return bean;
                    }
                }).to(type);
            }
        }
    }

    public List<Class<?>> getAllTypes(Object bean) {
        ArrayList types = new ArrayList();
        Collections.addAll(types, bean.getClass().getInterfaces());
        for (Class<?> type = bean.getClass(); type != null; type = type.getSuperclass()) {
            types.add(type);
        }
        return types;
    }
}

