/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.jobs.kernel.entities;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import org.tiogasolutions.couchace.core.api.CouchDatabase;
import org.tiogasolutions.couchace.core.api.CouchServer;
import org.tiogasolutions.dev.common.id.IdGenerator;
import org.tiogasolutions.dev.common.id.TimeUuidIdGenerator;
import org.tiogasolutions.jobs.kernel.entities.CouchServersConfig;
import org.tiogasolutions.jobs.kernel.entities.DomainProfileEntity;
import org.tiogasolutions.jobs.kernel.support.JobsCouchServer;
import org.tiogasolutions.lib.couchace.DefaultCouchStore;
import org.tiogasolutions.lib.couchace.support.CouchUtils;

@Named
public class DomainProfileStore
extends DefaultCouchStore<DomainProfileEntity> {
    public static final String DOMAIN_PROFILE_DESIGN_NAME = "domainProfile";
    private final String databaseName;

    @Inject
    public DomainProfileStore(CouchServersConfig config) {
        super((CouchServer)JobsCouchServer.newMasterDb(config), DomainProfileEntity.class);
        this.databaseName = config.getMasterDatabaseName();
    }

    public String getDesignName() {
        return DOMAIN_PROFILE_DESIGN_NAME;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public JobsCouchServer getCouchServer() {
        return (JobsCouchServer)super.getCouchServer();
    }

    public void createDatabase(CouchDatabase database) {
        CouchUtils.createDatabase((CouchDatabase)database, (IdGenerator)new TimeUuidIdGenerator(), (String[])new String[]{"/jobs-agent/json-docs/domainProfile-test.json"});
        List<String> entities = Arrays.asList("entity", DOMAIN_PROFILE_DESIGN_NAME);
        CouchUtils.validateDesign((CouchDatabase)database, entities, (String)"/jobs-agent/design-docs/", (String)"-design.json");
    }

    public List<DomainProfileEntity> getAll() {
        return this.getEntityResponse("entity", "byEntityType", Collections.singletonList(DOMAIN_PROFILE_DESIGN_NAME)).getEntityList();
    }

    public DomainProfileEntity getByDomainName(String domainName) {
        List list = super.getEntities("byDomainName", new String[]{domainName});
        return list.isEmpty() ? null : (DomainProfileEntity)list.get(0);
    }

    public DomainProfileEntity getByApiKey(String byApiKey) {
        List list = super.getEntities("byApiKey", new String[]{byApiKey});
        return list.isEmpty() ? null : (DomainProfileEntity)list.get(0);
    }
}

