/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.jobs.agent.core.resources;

import java.util.Map;
import org.tiogasolutions.dev.common.EnvUtils;

public class JobVariable {
    private final String text;
    private final String name;

    public JobVariable(String text) {
        this.text = text;
        this.name = text.substring(2, text.length() - 1);
    }

    public String getText() {
        return this.text;
    }

    public String getName() {
        return this.name;
    }

    public static JobVariable findFirst(String text) {
        int posA = text.indexOf("${");
        if (posA < 0) {
            return null;
        }
        for (int posB = posA + 2; posB < text.length(); ++posB) {
            char chr = text.charAt(posB);
            if (Character.isWhitespace(chr)) {
                return null;
            }
            if (chr != '}') continue;
            String key = text.substring(posA, posB + 1);
            return new JobVariable(key);
        }
        return null;
    }

    public String replace(Map<String, String> substitutionsMap, String command) {
        String value = this.findProperty(substitutionsMap);
        if (value == null) {
            String msg = String.format("The property \"%s\" was not found in the specified map, system properties or environment variables.", this.name);
            throw new IllegalArgumentException(msg);
        }
        return command.replace(this.text, value);
    }

    private String findProperty(Map<String, String> substitutionsMap) {
        if (substitutionsMap.containsKey(this.name)) {
            return substitutionsMap.get(this.name);
        }
        return EnvUtils.findProperty((String)this.name);
    }
}

