/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.couchace.core.api.query;

import org.tiogasolutions.couchace.core.api.query.CouchJsonKey;
import org.tiogasolutions.couchace.core.internal.util.ArgUtil;

public class CouchViewQuery {
    private final String designName;
    private final String viewName;
    private final CouchJsonKey startKey;
    private final CouchJsonKey endKey;
    private final CouchJsonKey key;
    private final int limit;
    private final int skip;
    private boolean descending = false;
    private boolean includeDocs = true;

    public static CouchViewQueryBuilder builder(String designName, String viewName) {
        return new CouchViewQueryBuilder(designName, viewName);
    }

    public CouchViewQuery(String designName, String viewName, int limit, int skip, CouchJsonKey startKey, CouchJsonKey endKey, CouchJsonKey key, boolean descending, boolean includeDocs) {
        ArgUtil.assertNotNull(designName, "designName");
        ArgUtil.assertNotNull(viewName, "viewName");
        this.designName = designName;
        this.viewName = viewName;
        this.startKey = startKey;
        this.endKey = endKey;
        this.key = key;
        this.limit = limit;
        this.skip = skip;
        this.descending = descending;
        this.includeDocs = includeDocs;
    }

    public String getDesignName() {
        return this.designName;
    }

    public String getViewName() {
        return this.viewName;
    }

    public boolean hasStartKey() {
        return this.startKey != null;
    }

    public CouchJsonKey getStartKey() {
        return this.startKey;
    }

    public String getStartKeyJson() {
        return this.startKey.getJsonValue();
    }

    public boolean hasEndKey() {
        return this.endKey != null;
    }

    public CouchJsonKey getEndKey() {
        return this.endKey;
    }

    public String getEndKeyJson() {
        return this.endKey.getJsonValue();
    }

    public boolean hasKey() {
        return this.key != null;
    }

    public CouchJsonKey getKey() {
        return this.key;
    }

    public String getKeyJson() {
        return this.key.getJsonValue();
    }

    public int getLimit() {
        return this.limit;
    }

    public int getSkip() {
        return this.skip;
    }

    public boolean isDescending() {
        return this.descending;
    }

    public CouchViewQuery setDescending(boolean descending) {
        this.descending = descending;
        return this;
    }

    public boolean isIncludeDocs() {
        return this.includeDocs;
    }

    public CouchViewQuery setIncludeDocs(boolean includeDocs) {
        this.includeDocs = includeDocs;
        return this;
    }

    private static CouchJsonKey toJsonKey(Object ... keys) {
        if (keys == null || keys.length == 0) {
            return null;
        }
        if (keys.length == 1 && keys[0] instanceof CouchJsonKey) {
            return (CouchJsonKey)keys[0];
        }
        return new CouchJsonKey(keys);
    }

    public static class CouchViewQueryBuilder {
        private final String designName;
        private final String viewName;
        private CouchJsonKey startKey;
        private CouchJsonKey endKey;
        private CouchJsonKey key;
        private int limit;
        private int skip;
        private boolean descending = false;
        private boolean includeDocs = true;

        public CouchViewQueryBuilder(String designName, String viewName) {
            this.designName = designName;
            this.viewName = viewName;
        }

        public CouchViewQuery build() {
            return new CouchViewQuery(this.designName, this.viewName, this.limit, this.skip, this.startKey, this.endKey, this.key, this.descending, this.includeDocs);
        }

        public CouchViewQueryBuilder key(Object ... key) {
            this.key = CouchViewQuery.toJsonKey(key);
            return this;
        }

        public CouchViewQueryBuilder start(Object ... startKey) {
            this.startKey = CouchViewQuery.toJsonKey(startKey);
            return this;
        }

        public CouchViewQueryBuilder end(Object ... endKey) {
            this.endKey = CouchViewQuery.toJsonKey(endKey);
            return this;
        }

        public CouchViewQueryBuilder limit(int limit) {
            this.limit = limit;
            return this;
        }

        public CouchViewQueryBuilder skip(int skip) {
            this.skip = skip;
            return this;
        }

        public CouchViewQueryBuilder descending(boolean descending) {
            this.descending = descending;
            return this;
        }

        public CouchViewQueryBuilder includeDocs(boolean includeDocs) {
            this.includeDocs = includeDocs;
            return this;
        }
    }
}

