/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.jobs.agent.core;

import java.util.Arrays;
import javax.xml.bind.DatatypeConverter;
import org.tiogasolutions.couchace.core.api.CouchDatabase;
import org.tiogasolutions.couchace.core.api.request.CouchFeature;
import org.tiogasolutions.couchace.core.api.request.CouchFeatureSet;
import org.tiogasolutions.jobs.agent.core.JobsApplication;
import org.tiogasolutions.lib.couchace.DefaultCouchServer;

public class TestFactory {
    public static final String API_KEY = "9999";
    public static final String API_PASSWORD = "unittest";
    private static final String SYS_DB_NAME = "test-jobs";
    private static final String SYS_DB_PREFIX = "test-jobs-";
    private static final String SYS_DB_SUFFIX = "-domain";
    private final JobsApplication app;

    public static JobsApplication newApplication() {
        return new JobsApplication(SYS_DB_NAME, SYS_DB_PREFIX, SYS_DB_SUFFIX);
    }

    public TestFactory(JobsApplication app) throws Exception {
        String sysDatabase = "";
        String usrDatabase = "";
        this.app = app;
        DefaultCouchServer server = new DefaultCouchServer();
        for (String dbName : Arrays.asList(sysDatabase, usrDatabase)) {
            CouchDatabase database = server.database(dbName, CouchFeatureSet.builder().add(CouchFeature.ALLOW_DB_DELETE, (Object)true).build());
            if (!database.exists()) continue;
            database.deleteDatabase();
        }
    }

    public String toHttpAuth(String username, String password) {
        byte[] value = (username + ":" + password).getBytes();
        return "Basic " + DatatypeConverter.printBase64Binary((byte[])value);
    }

    public JobsApplication getApp() {
        return this.app;
    }
}

