/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.jobs.pub;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.File;
import java.nio.file.Path;
import java.util.concurrent.TimeUnit;
import org.tiogasolutions.jobs.pub.ActionType;

public class JobAction {
    private final ActionType actionType;
    private final String command;
    private final File workingDirectory;
    private long timeout;
    private TimeUnit timeoutUnit;

    @JsonCreator
    private JobAction(@JsonProperty(value="actionType") ActionType actionType, @JsonProperty(value="command") String command, @JsonProperty(value="workingDirectory") String dir, @JsonProperty(value="timeout") long timeout, @JsonProperty(value="timeoutUnit") TimeUnit timeoutUnit) {
        this.command = command;
        this.actionType = actionType;
        this.workingDirectory = (dir == null ? new File("") : new File(dir)).getAbsoluteFile();
        this.timeout = timeout;
        this.timeoutUnit = timeoutUnit;
    }

    public ActionType getActionType() {
        return this.actionType;
    }

    public String getCommand() {
        return this.command;
    }

    public File getWorkingDirectory() {
        return this.workingDirectory;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public TimeUnit getTimeoutUnit() {
        return this.timeoutUnit;
    }

    public static JobAction newJobAction(ActionType actionType, String command, File workingDirectory, long timeout, TimeUnit timeoutUnit) {
        return new JobAction(actionType, command, workingDirectory.getAbsolutePath(), timeout, timeoutUnit);
    }

    public static JobAction newJobAction(ActionType actionType, String command, Path workingDirectory, long timeout, TimeUnit timeoutUnit) {
        return new JobAction(actionType, command, workingDirectory.toFile().getAbsolutePath(), timeout, timeoutUnit);
    }
}

