/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.jobs.kernel.entities;

import java.util.Collections;
import org.tiogasolutions.couchace.core.api.CouchDatabase;
import org.tiogasolutions.dev.common.id.IdGenerator;
import org.tiogasolutions.dev.common.id.TimeUuidIdGenerator;
import org.tiogasolutions.jobs.kernel.support.ExecutionContextManager;
import org.tiogasolutions.jobs.kernel.support.JobsCouchServer;
import org.tiogasolutions.lib.couchace.support.CouchUtils;

public class DomainDatabaseConfig {
    private final JobsCouchServer couchServer;
    private final ExecutionContextManager ecm;
    private final String dbNamePrefix;
    private final String dbNameSuffix;

    public DomainDatabaseConfig(JobsCouchServer couchServer, ExecutionContextManager ecm, String dbNamePrefix, String dbNameSuffix) {
        this.couchServer = couchServer;
        this.ecm = ecm;
        this.dbNamePrefix = dbNamePrefix;
        this.dbNameSuffix = dbNameSuffix;
    }

    public JobsCouchServer getCouchServer() {
        return this.couchServer;
    }

    public ExecutionContextManager getEcm() {
        return this.ecm;
    }

    public String getDbNamePrefix() {
        return this.dbNamePrefix;
    }

    public String getDbNameSuffix() {
        return this.dbNameSuffix;
    }

    public void createDatabase(CouchDatabase database) {
        CouchUtils.createDatabase((CouchDatabase)database, (IdGenerator)new TimeUuidIdGenerator(), (String[])new String[]{"/jobs-agent/json-docs/jobDefinition-test-a.json", "/jobs-agent/json-docs/jobDefinition-test-b.json"});
        CouchUtils.validateDesign((CouchDatabase)database, Collections.singletonList("entity"), (String)"/jobs-agent/design-docs/", (String)"-design.json");
    }
}

