/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.jobs.pub;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.time.ZonedDateTime;

public class JobActionResult {
    private final String out;
    private final String err;
    private final String command;
    private final String failure;
    private final ZonedDateTime createdAt;
    private final ZonedDateTime completedAt;

    @JsonCreator
    private JobActionResult(@JsonProperty(value="command") String command, @JsonProperty(value="out") String out, @JsonProperty(value="err") String err, @JsonProperty(value="createdAt") ZonedDateTime createdAt, @JsonProperty(value="completedAt") ZonedDateTime completedAt, @JsonProperty(value="failure") String failure) {
        this.command = command;
        this.failure = failure;
        this.createdAt = createdAt;
        this.completedAt = completedAt;
        this.out = out == null ? null : out.replace("\r", "");
        this.err = err == null ? null : err.replace("\r", "");
    }

    public boolean hasFailure() {
        return this.failure != null;
    }

    public ZonedDateTime getCreatedAt() {
        return this.createdAt;
    }

    public ZonedDateTime getCompletedAt() {
        return this.completedAt;
    }

    public String getCommand() {
        return this.command;
    }

    public String getFailure() {
        return this.failure;
    }

    public String getOut() {
        return this.out;
    }

    public String getErr() {
        return this.err;
    }

    public static JobActionResult finished(String command, ZonedDateTime createdAt, int exitValue, String out, String err) {
        return new JobActionResult(command, out, err, createdAt, ZonedDateTime.now(), String.valueOf(exitValue));
    }

    public static JobActionResult fail(String command, ZonedDateTime createdAt, Exception ex) {
        StringWriter writer = new StringWriter();
        ex.printStackTrace(new PrintWriter(writer));
        String stackTrace = writer.toString();
        return new JobActionResult(command, null, null, createdAt, ZonedDateTime.now(), stackTrace);
    }
}

