/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.jobs.agent.core;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.core.Application;
import org.tiogasolutions.jobs.agent.core.resources.RootResourceV1;
import org.tiogasolutions.jobs.agent.core.support.JobsFilter;
import org.tiogasolutions.jobs.agent.core.support.JobsJaxRsExceptionMapper;
import org.tiogasolutions.jobs.agent.core.support.JobsReaderWriterProvider;
import org.tiogasolutions.jobs.agent.core.view.LocalResourceMessageBodyWriter;
import org.tiogasolutions.jobs.agent.core.view.ThymeleafMessageBodyWriter;
import org.tiogasolutions.jobs.kernel.entities.DomainDatabaseConfig;
import org.tiogasolutions.jobs.kernel.entities.DomainProfileStore;
import org.tiogasolutions.jobs.kernel.entities.JobDefinitionStore;
import org.tiogasolutions.jobs.kernel.entities.JobExecutionRequestStore;
import org.tiogasolutions.jobs.kernel.support.ExecutionContextManager;
import org.tiogasolutions.jobs.kernel.support.JobsCouchServer;

public class JobsApplication
extends Application {
    private final Set<Class<?>> classes;
    private final Map<String, Object> properties;
    private final String databaseName;
    private final String dbPrefix;
    private final String dbSuffix;

    public JobsApplication(String databaseName, String dbPrefix, String dbSuffix) {
        this.dbPrefix = dbPrefix;
        this.dbSuffix = dbSuffix;
        this.databaseName = databaseName;
        HashMap<String, Object> properties = new HashMap<String, Object>();
        HashSet<Class> classes = new HashSet<Class>();
        properties.put("app.admin.context", "/api/v1/admin");
        properties.put("app.client.context", "/api/v1/client");
        properties.put("system.username", "system");
        properties.put("system.password", "password");
        classes.add(JobsFilter.class);
        classes.add(RootResourceV1.class);
        classes.add(JobsReaderWriterProvider.class);
        classes.add(JobsJaxRsExceptionMapper.class);
        classes.add(ThymeleafMessageBodyWriter.class);
        classes.add(LocalResourceMessageBodyWriter.class);
        this.init(properties);
        this.classes = Collections.unmodifiableSet(classes);
        this.properties = Collections.unmodifiableMap(properties);
        this.checkForDuplicates();
    }

    private void init(Map<String, Object> properties) {
        JobsCouchServer couchServer = new JobsCouchServer();
        properties.put(JobsCouchServer.class.getName(), couchServer);
        ExecutionContextManager ecm = new ExecutionContextManager();
        properties.put(ExecutionContextManager.class.getName(), ecm);
        DomainProfileStore domainProfileStore = new DomainProfileStore(couchServer, this.databaseName);
        properties.put(DomainProfileStore.class.getName(), domainProfileStore);
        DomainDatabaseConfig config = new DomainDatabaseConfig(couchServer, ecm, this.dbPrefix, this.dbSuffix);
        JobDefinitionStore jobDefinitionStore = new JobDefinitionStore(config);
        properties.put(JobDefinitionStore.class.getName(), jobDefinitionStore);
        JobExecutionRequestStore jobExecutionRequestStore = new JobExecutionRequestStore(config);
        properties.put(JobExecutionRequestStore.class.getName(), jobExecutionRequestStore);
    }

    private void checkForDuplicates() {
        HashSet existing = new HashSet();
        for (Class<?> type : this.classes) {
            if (type == null || !existing.contains(type)) continue;
            String msg = String.format("The class %s has already been registered.", type.getName());
            throw new IllegalArgumentException(msg);
        }
        existing.clear();
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public String getDbPrefix() {
        return this.dbPrefix;
    }

    public String getDbSuffix() {
        return this.dbSuffix;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public Set<Class<?>> getClasses() {
        return this.classes;
    }

    public static <T> T get(Application app, Class<T> type) {
        return (T)app.getProperties().get(type.getName());
    }
}

