/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.app.thymeleaf;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.MessageBodyWriter;
import org.springframework.beans.factory.annotation.Autowired;
import org.thymeleaf.TemplateEngine;
import org.thymeleaf.context.IContext;
import org.thymeleaf.dialect.IDialect;
import org.thymeleaf.extras.java8time.dialect.Java8TimeDialect;
import org.thymeleaf.templateresolver.ITemplateResolver;
import org.tiogasolutions.app.thymeleaf.ClassPathTemplateResolver;
import org.tiogasolutions.app.thymeleaf.ThymeleafContent;
import org.tiogasolutions.app.thymeleaf.ThymeleafMessageBodyWriterConfig;

public class ThymeleafMessageBodyWriter
implements MessageBodyWriter<ThymeleafContent> {
    @Context
    private UriInfo uriInfo;
    private final TemplateEngine engine;

    @Autowired
    public ThymeleafMessageBodyWriter(ThymeleafMessageBodyWriterConfig config) {
        ClassPathTemplateResolver templateResolver = new ClassPathTemplateResolver();
        templateResolver.setTemplateMode("HTML5");
        templateResolver.setSuffix(config.getPathSuffix());
        templateResolver.setPrefix(config.getPathPrefix());
        templateResolver.setCacheable(config.isCacheable());
        this.engine = new TemplateEngine();
        this.engine.setTemplateResolver((ITemplateResolver)templateResolver);
        this.engine.addDialect((IDialect)new Java8TimeDialect());
    }

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return ThymeleafContent.class.equals(type);
    }

    public long getSize(ThymeleafContent thymeleaf, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    public String getBaseUri() {
        return this.uriInfo.getBaseUri().toASCIIString();
    }

    public void writeTo(ThymeleafContent thymeleaf, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        this.writeTo(thymeleaf, entityStream);
    }

    public void writeTo(ThymeleafContent thymeleaf, Writer writer) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.writeTo(thymeleaf, out);
        String text = new String(out.toByteArray(), Charset.forName("UTF-8"));
        writer.write(text);
    }

    public void writeTo(ThymeleafContent thymeleaf, OutputStream outputStream) throws IOException {
        String view = thymeleaf.getView();
        org.thymeleaf.context.Context context = new org.thymeleaf.context.Context();
        context.setVariables(thymeleaf.getVariables());
        String contextRoot = ThymeleafMessageBodyWriter.getContextRoot(this.uriInfo);
        context.setVariable("contextRoot", (Object)contextRoot);
        StringWriter writer = new StringWriter();
        this.engine.process(view, (IContext)context, (Writer)writer);
        String content = writer.toString();
        outputStream.write(content.getBytes());
    }

    public static String getContextRoot(UriInfo uriInfo) {
        if (uriInfo == null) {
            return "/";
        }
        String path = uriInfo.getBaseUri().toASCIIString();
        path = path.substring(0, path.length() - 1);
        return path.trim();
    }
}

