/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.dev.jerseyspring;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.WriteListener;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import org.glassfish.jersey.internal.PropertiesDelegate;
import org.glassfish.jersey.internal.util.collection.Ref;
import org.glassfish.jersey.message.internal.TracingLogger;
import org.glassfish.jersey.server.ContainerException;
import org.glassfish.jersey.server.ContainerRequest;
import org.glassfish.jersey.server.mvc.Viewable;
import org.glassfish.jersey.server.mvc.jsp.internal.LocalizationMessages;
import org.glassfish.jersey.server.mvc.spi.AbstractTemplateProcessor;
import org.tiogasolutions.dev.jerseyspring.TiogaRequestDispatcherWrapper;

public class TiogaJspTemplateProcessor
extends AbstractTemplateProcessor<String> {
    @Inject
    private Provider<Ref<HttpServletRequest>> requestProviderRef;
    @Inject
    private Provider<Ref<HttpServletResponse>> responseProviderRef;
    @Inject
    private Provider<ContainerRequest> containerRequestProvider;

    private static String[] determineSupportedExtensions(Configuration config) {
        Object supportedExtensionProperty = config.getProperty("org.tiogasolutions.dev.jersey-spring.supportedExtensions");
        if (supportedExtensionProperty == null) {
            return new String[]{"jsp"};
        }
        String[] extensions = supportedExtensionProperty.toString().split(",");
        for (int i = 0; i < extensions.length; ++i) {
            extensions[i] = extensions[i].trim();
        }
        return extensions;
    }

    @Inject
    public TiogaJspTemplateProcessor(Configuration config, ServletContext servletContext) {
        super(config, servletContext, "jsp", TiogaJspTemplateProcessor.determineSupportedExtensions(config));
    }

    protected String resolve(String templatePath, Reader reader) throws Exception {
        return templatePath;
    }

    public void writeTo(String templateReference, Viewable viewable, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, final OutputStream out) throws IOException {
        RequestDispatcher dispatcher;
        TracingLogger tracingLogger = TracingLogger.getInstance((PropertiesDelegate)((ContainerRequest)this.containerRequestProvider.get()).getPropertiesDelegate());
        if (tracingLogger.isLogEnabled((TracingLogger.Event)MvcJspEvent.JSP_FORWARD)) {
            tracingLogger.log((TracingLogger.Event)MvcJspEvent.JSP_FORWARD, new Object[]{templateReference, viewable.getModel()});
        }
        if ((dispatcher = this.getServletContext().getRequestDispatcher(templateReference)) == null) {
            throw new ContainerException(LocalizationMessages.NO_REQUEST_DISPATCHER_FOR_RESOLVED_PATH((Object)templateReference));
        }
        TiogaRequestDispatcherWrapper wrapper = new TiogaRequestDispatcherWrapper(dispatcher, this.getBasePath(), viewable);
        final ServletOutputStream responseStream = new ServletOutputStream(){

            public boolean isReady() {
                return true;
            }

            public void setWriteListener(WriteListener writeListener) {
            }

            public void write(int b) throws IOException {
                out.write(b);
            }
        };
        final PrintWriter responseWriter = new PrintWriter(new OutputStreamWriter((OutputStream)responseStream));
        try {
            wrapper.forward((ServletRequest)((Ref)this.requestProviderRef.get()).get(), (ServletResponse)new HttpServletResponseWrapper((HttpServletResponse)((Ref)this.responseProviderRef.get()).get()){

                public ServletOutputStream getOutputStream() throws IOException {
                    return responseStream;
                }

                public PrintWriter getWriter() throws IOException {
                    return responseWriter;
                }
            });
        }
        catch (Exception e) {
            throw new ContainerException((Throwable)e);
        }
        finally {
            responseWriter.flush();
        }
    }

    private static enum MvcJspEvent implements TracingLogger.Event
    {
        JSP_FORWARD(TracingLogger.Level.SUMMARY, "MVC", "Forwarding view to JSP page [%s], model %s");

        private final TracingLogger.Level level;
        private final String category;
        private final String messageFormat;

        private MvcJspEvent(TracingLogger.Level level, String category, String messageFormat) {
            this.level = level;
            this.category = category;
            this.messageFormat = messageFormat;
        }

        public String category() {
            return this.category;
        }

        public TracingLogger.Level level() {
            return this.level;
        }

        public String messageFormat() {
            return this.messageFormat;
        }
    }
}

