/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.apis.easypost.requests;

import javax.ws.rs.core.Form;
import org.tiogasolutions.apis.easypost.carrier.PredefinedPackage;

public class CreateParcelRequest {
    private final double weight;
    private final Double length;
    private final Double width;
    private final Double height;
    private final String predefinedPackage;

    public CreateParcelRequest(double weight, PredefinedPackage predefinedPackage) {
        this.weight = weight;
        this.predefinedPackage = predefinedPackage.getCode();
        this.length = null;
        this.width = null;
        this.height = null;
    }

    public CreateParcelRequest(double weight, double length, double width, double height) {
        this.weight = weight;
        this.length = length;
        this.width = width;
        this.height = height;
        this.predefinedPackage = null;
    }

    public double getWeight() {
        return this.weight;
    }

    public Double getLength() {
        return this.length;
    }

    public Double getWidth() {
        return this.width;
    }

    public Double getHeight() {
        return this.height;
    }

    public String getPredefinedPackage() {
        return this.predefinedPackage;
    }

    public Form toForm() {
        Form form = new Form();
        if (this.predefinedPackage != null) {
            form.param("parcel[weight]", String.valueOf(this.weight));
            form.param("parcel[predefined_package]", this.predefinedPackage);
        } else {
            form.param("parcel[weight]", String.valueOf(this.weight));
            form.param("parcel[length]", String.valueOf(this.length));
            form.param("parcel[width]", String.valueOf(this.width));
            form.param("parcel[height]", String.valueOf(this.height));
        }
        return form;
    }
}

