/*
 * Decompiled with CFR 0.152.
 */
package org.thatscloud.pubj.util.json;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.ResolvedType;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.deser.ContextualDeserializer;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.thatscloud.pubj.util.json.annotation.JsonKey;

public class ArrayToMapDeserialiser<K, V>
extends StdDeserializer<Map<K, V>>
implements ContextualDeserializer {
    private static final long serialVersionUID = 1L;
    private final Function<V, K> myKeyMapper;
    private final JavaType myValueType;

    public ArrayToMapDeserialiser() {
        this(null, null);
    }

    private ArrayToMapDeserialiser(Function<V, K> keyMapper, JavaType valueType) {
        super(Map.class);
        this.myKeyMapper = keyMapper;
        this.myValueType = valueType;
    }

    public Map<K, V> deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        return ((List)p.getCodec().readValue(p, (ResolvedType)ctxt.getTypeFactory().constructCollectionType(List.class, this.myValueType))).stream().filter(value -> this.myKeyMapper.apply(value) != null).collect(Collectors.toMap(this.myKeyMapper, Function.identity()));
    }

    public JsonDeserializer<?> createContextual(DeserializationContext ctxt, BeanProperty property) throws JsonMappingException {
        try {
            return new ArrayToMapDeserialiser(((JsonKey)property.getAnnotation(JsonKey.class)).value().newInstance(), property.getType().getContentType());
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException(e);
        }
    }
}

