/*
 * Decompiled with CFR 0.152.
 */
package org.thatscloud.pubj;

public class PubgConfig {
    private final long myDelayBetweenApiCallsInMilliseconds;
    private final String myBaseRestUrl;
    private final String myApiKey;

    public static PubgConfigBuilder builder() {
        return new PubgConfigBuilder();
    }

    private PubgConfig(PubgConfigBuilder pubgConfigBuilder) {
        this.myDelayBetweenApiCallsInMilliseconds = pubgConfigBuilder.myDelayBetweenApiCallsInMilliseconds;
        this.myBaseRestUrl = pubgConfigBuilder.myBaseRestUrl;
        this.myApiKey = pubgConfigBuilder.myApiKey;
    }

    public long getDelayBetweenApiCallsInMilliseconds() {
        return this.myDelayBetweenApiCallsInMilliseconds;
    }

    public String getBaseRestUrl() {
        return this.myBaseRestUrl;
    }

    public String getApiKey() {
        return this.myApiKey;
    }

    public static class PubgConfigBuilder {
        private long myDelayBetweenApiCallsInMilliseconds = 2200L;
        private String myBaseRestUrl = "https://api.pubgtracker.com/v2";
        private String myApiKey;

        private PubgConfigBuilder() {
        }

        public PubgConfigBuilder delayBetweenApiCallsInMilliseconds(long delayBetweenApiCallsInMilliseconds) {
            this.myDelayBetweenApiCallsInMilliseconds = delayBetweenApiCallsInMilliseconds;
            return this;
        }

        public PubgConfigBuilder baseRestUrl(String baseRestUrl) {
            this.myBaseRestUrl = baseRestUrl;
            return this;
        }

        public PubgConfigBuilder apiKey(String apiKey) {
            this.myApiKey = apiKey;
            return this;
        }

        public PubgConfig build() {
            return new PubgConfig(this);
        }
    }
}

