/*
 * Decompiled with CFR 0.152.
 */
package org.thatscloud.pubj;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.jaxrs.json.JacksonJsonProvider;
import com.fasterxml.jackson.module.paramnames.ParameterNamesModule;
import java.io.Closeable;
import java.time.Duration;
import java.time.Instant;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import org.thatscloud.pubj.PubgConfig;
import org.thatscloud.pubj.rest.model.Player;

public class Pubg
implements Closeable {
    private final long myMillisBetweenCalls;
    private final String myApiKey;
    private final String myBaseRestUrl;
    private final Client myClient;
    private Instant myLastApiCallTime;

    public Pubg(PubgConfig pubgConfig) {
        this.myMillisBetweenCalls = pubgConfig.getDelayBetweenApiCallsInMilliseconds();
        this.myBaseRestUrl = pubgConfig.getBaseRestUrl();
        this.myApiKey = pubgConfig.getApiKey();
        this.myLastApiCallTime = Instant.MIN;
        this.myClient = (Client)((Client)((Client)((Client)ClientBuilder.newClient().property("jersey.config.disableAutoDiscovery", (Object)true)).property("jersey.config.disableJsonProcessing", (Object)true)).property("jersey.config.disableMetainfServicesLookup", (Object)true)).register((Object)new JacksonJsonProvider(new ObjectMapper().registerModule((Module)new ParameterNamesModule()).registerModule((Module)new Jdk8Module()).registerModule((Module)new JavaTimeModule()).configure(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL, true)));
    }

    public Pubg(String apiKey) {
        this(PubgConfig.builder().apiKey(apiKey).build());
    }

    private synchronized void waitForCallRateLimit() {
        if (this.myMillisBetweenCalls > 0L) {
            while (this.myLastApiCallTime.plusMillis(this.myMillisBetweenCalls).isAfter(Instant.now())) {
                try {
                    Thread.sleep(Duration.between(Instant.now(), this.myLastApiCallTime.plusMillis(this.myMillisBetweenCalls)).toMillis());
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    public synchronized Player getPlayer(String playerName) {
        this.waitForCallRateLimit();
        try {
            Player player = (Player)this.myClient.target(this.myBaseRestUrl).path("profile").path("pc").path(playerName).request().header("TRN-Api-Key", (Object)this.myApiKey).get(Player.class);
            return player;
        }
        finally {
            this.myLastApiCallTime = Instant.now();
        }
    }

    @Override
    public void close() {
        this.myClient.close();
    }
}

