/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.containers;

import lombok.NonNull;
import org.testcontainers.containers.JdbcDatabaseContainer;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitStrategy;
import org.testcontainers.containers.wait.strategy.WaitStrategyTarget;
import org.testcontainers.utility.DockerImageName;

public class QuestDBContainer
extends JdbcDatabaseContainer<QuestDBContainer> {
    @Deprecated
    static final String LEGACY_DATABASE_PROVIDER = "postgresql";
    static final String DATABASE_PROVIDER = "questdb";
    private static final String DEFAULT_DATABASE_NAME = "qdb";
    private static final int DEFAULT_COMMIT_LAG_MS = 1000;
    private static final String DEFAULT_USERNAME = "admin";
    private static final String DEFAULT_PASSWORD = "quest";
    private static final Integer POSTGRES_PORT = 8812;
    private static final Integer REST_PORT = 9000;
    private static final Integer ILP_PORT = 9009;
    static final String TEST_QUERY = "SELECT 1";
    static final DockerImageName DEFAULT_IMAGE_NAME = DockerImageName.parse((String)"questdb/questdb");

    public QuestDBContainer(@NonNull String dockerImageName) {
        this(DockerImageName.parse((String)dockerImageName));
        if (dockerImageName == null) {
            throw new NullPointerException("dockerImageName is marked non-null but is null");
        }
    }

    public QuestDBContainer(DockerImageName dockerImageName) {
        super(dockerImageName);
        dockerImageName.assertCompatibleWith(new DockerImageName[]{DEFAULT_IMAGE_NAME});
        this.withExposedPorts(new Integer[]{POSTGRES_PORT, REST_PORT, ILP_PORT});
        this.addEnv("QDB_CAIRO_COMMIT_LAG", String.valueOf(1000));
        this.waitingFor((WaitStrategy)Wait.forLogMessage((String)"(?i).*A server-main enjoy.*", (int)1));
    }

    public String getDriverClassName() {
        return "org.postgresql.Driver";
    }

    public String getJdbcUrl() {
        return String.format("jdbc:postgresql://%s:%d/%s", this.getHost(), this.getMappedPort(8812), this.getDefaultDatabaseName());
    }

    public String getUsername() {
        return DEFAULT_USERNAME;
    }

    public String getPassword() {
        return DEFAULT_PASSWORD;
    }

    public String getTestQueryString() {
        return TEST_QUERY;
    }

    protected void waitUntilContainerStarted() {
        this.getWaitStrategy().waitUntilReady((WaitStrategyTarget)this);
    }

    public String getDefaultDatabaseName() {
        return DEFAULT_DATABASE_NAME;
    }

    public String getIlpUrl() {
        return this.getHost() + ":" + this.getMappedPort(ILP_PORT);
    }

    public String getHttpUrl() {
        return "http://" + this.getHost() + ":" + this.getMappedPort(REST_PORT);
    }
}

