/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.containers;

import com.datastax.driver.core.Cluster;
import com.github.dockerjava.api.command.InspectContainerResponse;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import javax.script.ScriptException;
import org.testcontainers.containers.ContainerState;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.delegate.CassandraDatabaseDelegate;
import org.testcontainers.delegate.DatabaseDelegate;
import org.testcontainers.ext.ScriptUtils;
import org.testcontainers.shaded.org.apache.commons.io.IOUtils;
import org.testcontainers.utility.DockerImageName;
import org.testcontainers.utility.MountableFile;

@Deprecated
public class CassandraContainer<SELF extends CassandraContainer<SELF>>
extends GenericContainer<SELF> {
    private static final DockerImageName DEFAULT_IMAGE_NAME = DockerImageName.parse((String)"cassandra");
    private static final String DEFAULT_TAG = "3.11.2";
    @Deprecated
    public static final String IMAGE = DEFAULT_IMAGE_NAME.getUnversionedPart();
    public static final Integer CQL_PORT = 9042;
    private static final String DEFAULT_LOCAL_DATACENTER = "datacenter1";
    private static final String CONTAINER_CONFIG_LOCATION = "/etc/cassandra";
    private static final String USERNAME = "cassandra";
    private static final String PASSWORD = "cassandra";
    private String configLocation;
    private String initScriptPath;
    private boolean enableJmxReporting;

    @Deprecated
    public CassandraContainer() {
        this(DEFAULT_IMAGE_NAME.withTag(DEFAULT_TAG));
    }

    public CassandraContainer(String dockerImageName) {
        this(DockerImageName.parse((String)dockerImageName));
    }

    public CassandraContainer(DockerImageName dockerImageName) {
        super(dockerImageName);
        dockerImageName.assertCompatibleWith(new DockerImageName[]{DEFAULT_IMAGE_NAME});
        this.addExposedPort(CQL_PORT);
        this.enableJmxReporting = false;
        this.withEnv("CASSANDRA_SNITCH", "GossipingPropertyFileSnitch");
        this.withEnv("JVM_OPTS", "-Dcassandra.skip_wait_for_gossip_to_settle=0 -Dcassandra.initial_token=0");
        this.withEnv("HEAP_NEWSIZE", "128M");
        this.withEnv("MAX_HEAP_SIZE", "1024M");
        this.withEnv("CASSANDRA_ENDPOINT_SNITCH", "GossipingPropertyFileSnitch");
        this.withEnv("CASSANDRA_DC", DEFAULT_LOCAL_DATACENTER);
    }

    protected void configure() {
        this.optionallyMapResourceParameterAsVolume(CONTAINER_CONFIG_LOCATION, this.configLocation);
    }

    protected void containerIsStarted(InspectContainerResponse containerInfo) {
        this.runInitScriptIfRequired();
    }

    private void runInitScriptIfRequired() {
        if (this.initScriptPath != null) {
            try {
                URL resource = Thread.currentThread().getContextClassLoader().getResource(this.initScriptPath);
                if (resource == null) {
                    this.logger().warn("Could not load classpath init script: {}", (Object)this.initScriptPath);
                    throw new ScriptUtils.ScriptLoadException("Could not load classpath init script: " + this.initScriptPath + ". Resource not found.");
                }
                String cql = IOUtils.toString((URL)resource, (Charset)StandardCharsets.UTF_8);
                DatabaseDelegate databaseDelegate = this.getDatabaseDelegate();
                ScriptUtils.executeDatabaseScript((DatabaseDelegate)databaseDelegate, (String)this.initScriptPath, (String)cql);
            }
            catch (IOException e) {
                this.logger().warn("Could not load classpath init script: {}", (Object)this.initScriptPath);
                throw new ScriptUtils.ScriptLoadException("Could not load classpath init script: " + this.initScriptPath, (Throwable)e);
            }
            catch (ScriptException e) {
                this.logger().error("Error while executing init script: {}", (Object)this.initScriptPath, (Object)e);
                throw new ScriptUtils.UncategorizedScriptException("Error while executing init script: " + this.initScriptPath, (Exception)e);
            }
        }
    }

    protected void optionallyMapResourceParameterAsVolume(String pathNameInContainer, String resourceLocation) {
        Optional.ofNullable(resourceLocation).map(MountableFile::forClasspathResource).ifPresent(mountableFile -> {
            CassandraContainer cfr_ignored_0 = (CassandraContainer)this.withCopyFileToContainer((MountableFile)mountableFile, pathNameInContainer);
        });
    }

    public SELF withConfigurationOverride(String configLocation) {
        this.configLocation = configLocation;
        return (SELF)((Object)((CassandraContainer)this.self()));
    }

    public SELF withInitScript(String initScriptPath) {
        this.initScriptPath = initScriptPath;
        return (SELF)((Object)((CassandraContainer)this.self()));
    }

    public SELF withJmxReporting(boolean enableJmxReporting) {
        this.enableJmxReporting = enableJmxReporting;
        return (SELF)((Object)((CassandraContainer)this.self()));
    }

    public String getUsername() {
        return "cassandra";
    }

    public String getPassword() {
        return "cassandra";
    }

    @Deprecated
    public Cluster getCluster() {
        return CassandraContainer.getCluster((ContainerState)this, this.enableJmxReporting);
    }

    @Deprecated
    public static Cluster getCluster(ContainerState containerState, boolean enableJmxReporting) {
        Cluster.Builder builder = Cluster.builder().addContactPoint(containerState.getHost()).withPort(containerState.getMappedPort(CQL_PORT.intValue()).intValue());
        if (!enableJmxReporting) {
            builder.withoutJMXReporting();
        }
        return builder.build();
    }

    @Deprecated
    public static Cluster getCluster(ContainerState containerState) {
        return CassandraContainer.getCluster(containerState, false);
    }

    public InetSocketAddress getContactPoint() {
        return new InetSocketAddress(this.getHost(), (int)this.getMappedPort(CQL_PORT));
    }

    public String getLocalDatacenter() {
        return this.getEnvMap().getOrDefault("CASSANDRA_DC", DEFAULT_LOCAL_DATACENTER);
    }

    @Deprecated
    private DatabaseDelegate getDatabaseDelegate() {
        return new CassandraDatabaseDelegate((ContainerState)this);
    }
}

