/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.angela.ehc3;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.stream.Stream;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.angela.KitResolver;
import org.terracotta.angela.common.tcconfig.License;
import org.terracotta.angela.common.topology.LicenseType;
import org.terracotta.angela.common.topology.PackageType;
import org.terracotta.angela.common.topology.Version;

public class Ehc3KitResolver
extends KitResolver {
    private static final Logger logger = LoggerFactory.getLogger(Ehc3KitResolver.class);

    public String resolveLocalInstallerPath(Version version, LicenseType licenseType, PackageType packageType) {
        if (packageType == PackageType.KIT) {
            return "ehcache-clustered-" + version.getVersion(true) + "-kit.zip";
        }
        throw new IllegalArgumentException("PackageType " + packageType + " is not supported by " + ((Object)((Object)this)).getClass().getSimpleName() + " in the Open source version.");
    }

    public void createLocalInstallFromInstaller(Version version, PackageType packageType, License license, Path localInstallerPath, Path rootInstallationPath) {
        if (packageType != PackageType.KIT) {
            throw new IllegalArgumentException("PackageType " + packageType + " is not supported by " + ((Object)((Object)this)).getClass().getSimpleName());
        }
        this.extract(localInstallerPath, rootInstallationPath);
    }

    private void extract(Path kitInstaller, Path kitDest) {
        try {
            this.extractZip(kitInstaller, kitDest);
        }
        catch (IOException ioe) {
            throw new UncheckedIOException("Error when extracting installer package", ioe);
        }
        logger.info("kit installation path: {}", (Object)kitDest.toAbsolutePath());
    }

    private void extractZip(Path kitInstaller, Path kitDest) throws IOException {
        try (ZipArchiveInputStream archiveIs = new ZipArchiveInputStream((InputStream)new BufferedInputStream(Files.newInputStream(kitInstaller, new OpenOption[0])));){
            this.extractArchive((ArchiveInputStream)archiveIs, kitDest);
        }
        this.cleanupPermissions(kitDest);
    }

    private void extractArchive(ArchiveInputStream archiveIs, Path pathOutput) throws IOException {
        ArchiveEntry archiveEntry;
        while ((archiveEntry = archiveIs.getNextEntry()) != null) {
            Path pathEntryOutput = pathOutput.resolve(archiveEntry.getName());
            if (archiveEntry.isDirectory()) continue;
            Path parentPath = pathEntryOutput.getParent();
            if (!Files.isDirectory(parentPath, new LinkOption[0])) {
                Files.createDirectories(parentPath, new FileAttribute[0]);
            }
            Files.copy((InputStream)archiveIs, pathEntryOutput, new CopyOption[0]);
        }
    }

    private void cleanupPermissions(Path dest) {
        if (!FileSystems.getDefault().supportedFileAttributeViews().contains("posix")) {
            return;
        }
        try (Stream<Path> walk = Files.walk(dest, new FileVisitOption[0]);){
            walk.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(path -> {
                String name = path.getFileName().toString();
                return name.endsWith(".sh") || name.endsWith("tms.jar");
            }).forEach(path -> {
                try {
                    HashSet<PosixFilePermission> perms = new HashSet<PosixFilePermission>(Files.getPosixFilePermissions(path, new LinkOption[0]));
                    perms.addAll(EnumSet.of(PosixFilePermission.OWNER_EXECUTE, PosixFilePermission.GROUP_EXECUTE, PosixFilePermission.OTHERS_EXECUTE));
                    Files.setPosixFilePermissions(path, perms);
                }
                catch (IOException ioe) {
                    throw new UncheckedIOException(ioe);
                }
            });
        }
        catch (IOException ioe) {
            throw new UncheckedIOException(ioe);
        }
    }

    public Path resolveKitInstallationPath(Version version, PackageType packageType, Path localInstallerPath, Path rootInstallationPath) {
        return rootInstallationPath.resolve(this.getDirFromArchive(packageType, localInstallerPath));
    }

    private String getDirFromArchive(PackageType packageType, Path localInstaller) {
        if (packageType == PackageType.KIT) {
            return this.getParentDirFromZip(localInstaller);
        }
        throw new IllegalArgumentException("PackageType " + packageType + " is not supported by " + ((Object)((Object)this)).getClass().getSimpleName());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getParentDirFromZip(Path localInstaller) {
        try (ZipArchiveInputStream archiveIs = new ZipArchiveInputStream((InputStream)new BufferedInputStream(Files.newInputStream(localInstaller, new OpenOption[0])));){
            ArchiveEntry entry = archiveIs.getNextEntry();
            String string = entry.getName().split("/")[0];
            return string;
        }
        catch (IOException ioe) {
            throw new UncheckedIOException(ioe);
        }
    }

    public URL[] resolveKitUrls(Version version, LicenseType licenseType, PackageType packageType) {
        try {
            if (packageType == PackageType.KIT) {
                String realVersion = version.getVersion(true);
                StringBuilder sb = new StringBuilder("https://oss.sonatype.org/service/local/artifact/maven/redirect?").append("g=org.ehcache&").append("a=ehcache-clustered&").append("c=kit&").append(realVersion.contains("SNAPSHOT") ? "r=snapshots&" : "r=releases&").append("v=").append(realVersion).append("&").append("e=zip");
                URL kitUrl = new URL(sb.toString());
                URL md5Url = new URL(sb.toString() + ".md5");
                return new URL[]{kitUrl, md5Url};
            }
            throw new IllegalArgumentException("PackageType " + packageType + " is not supported by " + ((Object)((Object)this)).getClass().getSimpleName());
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Can not resolve the url for the distribution package: " + packageType + ", " + licenseType + ", " + version, e);
        }
    }

    public boolean supports(LicenseType licenseType) {
        return licenseType == LicenseType.EHCACHE_OS;
    }
}

