/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.visor.cache;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.ignite.cache.CacheMetrics;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.processors.cache.GridCacheProcessor;
import org.apache.ignite.internal.processors.cache.IgniteCacheProxy;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.visor.VisorDataTransferObject;
import org.apache.ignite.internal.visor.query.VisorQueryMetrics;

public class VisorCacheMetrics
extends VisorDataTransferObject {
    private static final long serialVersionUID = 0L;
    private static final float MICROSECONDS_IN_SECOND = 1000000.0f;
    private String name;
    private CacheMode mode;
    private boolean sys;
    private int size;
    private int keySize;
    private long cacheSize;
    private long reads;
    private float avgReadTime;
    private long writes;
    private long hits;
    private long misses;
    private long txCommits;
    private float avgTxCommitTime;
    private long txRollbacks;
    private float avgTxRollbackTime;
    private long puts;
    private float avgPutTime;
    private long removals;
    private float avgRemovalTime;
    private long evictions;
    private int readsPerSec;
    private int putsPerSec;
    private int removalsPerSec;
    private int commitsPerSec;
    private int rollbacksPerSec;
    private int dhtEvictQueueCurrSize;
    private int txThreadMapSize;
    private int txXidMapSize;
    private int txCommitQueueSize;
    private int txPrepareQueueSize;
    private int txStartVerCountsSize;
    private int txCommittedVersionsSize;
    private int txRolledbackVersionsSize;
    private int txDhtThreadMapSize;
    private int txDhtXidMapSize;
    private int txDhtCommitQueueSize;
    private int txDhtPrepareQueueSize;
    private int txDhtStartVerCountsSize;
    private int txDhtCommittedVersionsSize;
    private int txDhtRolledbackVersionsSize;
    private long heapEntriesCnt;
    private long offHeapAllocatedSize;
    private long offHeapEntriesCnt;
    private long offHeapPrimaryEntriesCnt;
    private int totalPartsCnt;
    private long rebalancedKeys;
    private long estimatedRebalancingKeys;
    private int rebalancingPartsCnt;
    private long keysToRebalanceLeft;
    private long rebalancingKeysRate;
    private long rebalancingBytesRate;
    private VisorQueryMetrics qryMetrics;

    private static int perSecond(float meanTime) {
        return meanTime > 0.0f ? (int)(1000000.0f / meanTime) : 0;
    }

    public VisorCacheMetrics() {
    }

    public VisorCacheMetrics(IgniteEx ignite, String cacheName) {
        GridCacheProcessor cacheProcessor = ignite.context().cache();
        IgniteCacheProxy c = cacheProcessor.jcache(cacheName);
        this.name = cacheName;
        this.mode = cacheProcessor.cacheMode(cacheName);
        this.sys = cacheProcessor.systemCache(cacheName);
        CacheMetrics m = c.localMetrics();
        this.size = m.getSize();
        this.keySize = m.getKeySize();
        this.cacheSize = m.getCacheSize();
        this.reads = m.getCacheGets();
        this.writes = m.getCachePuts() + m.getCacheRemovals();
        this.hits = m.getCacheHits();
        this.misses = m.getCacheMisses();
        this.txCommits = m.getCacheTxCommits();
        this.txRollbacks = m.getCacheTxRollbacks();
        this.avgTxCommitTime = m.getAverageTxCommitTime();
        this.avgTxRollbackTime = m.getAverageTxRollbackTime();
        this.puts = m.getCachePuts();
        this.removals = m.getCacheRemovals();
        this.evictions = m.getCacheEvictions();
        this.avgReadTime = m.getAverageGetTime();
        this.avgPutTime = m.getAveragePutTime();
        this.avgRemovalTime = m.getAverageRemoveTime();
        this.readsPerSec = VisorCacheMetrics.perSecond(m.getAverageGetTime());
        this.putsPerSec = VisorCacheMetrics.perSecond(m.getAveragePutTime());
        this.removalsPerSec = VisorCacheMetrics.perSecond(m.getAverageRemoveTime());
        this.commitsPerSec = VisorCacheMetrics.perSecond(m.getAverageTxCommitTime());
        this.rollbacksPerSec = VisorCacheMetrics.perSecond(m.getAverageTxRollbackTime());
        this.dhtEvictQueueCurrSize = m.getDhtEvictQueueCurrentSize();
        this.txThreadMapSize = m.getTxThreadMapSize();
        this.txXidMapSize = m.getTxXidMapSize();
        this.txCommitQueueSize = m.getTxCommitQueueSize();
        this.txPrepareQueueSize = m.getTxPrepareQueueSize();
        this.txStartVerCountsSize = m.getTxStartVersionCountsSize();
        this.txCommittedVersionsSize = m.getTxCommittedVersionsSize();
        this.txRolledbackVersionsSize = m.getTxRolledbackVersionsSize();
        this.txDhtThreadMapSize = m.getTxDhtThreadMapSize();
        this.txDhtXidMapSize = m.getTxDhtXidMapSize();
        this.txDhtCommitQueueSize = m.getTxDhtCommitQueueSize();
        this.txDhtPrepareQueueSize = m.getTxDhtPrepareQueueSize();
        this.txDhtStartVerCountsSize = m.getTxDhtStartVersionCountsSize();
        this.txDhtCommittedVersionsSize = m.getTxDhtCommittedVersionsSize();
        this.txDhtRolledbackVersionsSize = m.getTxDhtRolledbackVersionsSize();
        this.heapEntriesCnt = m.getHeapEntriesCount();
        this.offHeapAllocatedSize = m.getOffHeapAllocatedSize();
        this.offHeapEntriesCnt = m.getOffHeapEntriesCount();
        this.offHeapPrimaryEntriesCnt = m.getOffHeapPrimaryEntriesCount();
        this.totalPartsCnt = m.getTotalPartitionsCount();
        this.rebalancedKeys = m.getRebalancedKeys();
        this.estimatedRebalancingKeys = m.getEstimatedRebalancingKeys();
        this.rebalancingPartsCnt = m.getRebalancingPartitionsCount();
        this.keysToRebalanceLeft = m.getKeysToRebalanceLeft();
        this.rebalancingKeysRate = m.getRebalancingKeysRate();
        this.rebalancingBytesRate = m.getRebalancingBytesRate();
        this.qryMetrics = new VisorQueryMetrics(c.queryMetrics());
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public CacheMode getMode() {
        return this.mode;
    }

    public boolean isSystem() {
        return this.sys;
    }

    public long getReads() {
        return this.reads;
    }

    public float getAvgReadTime() {
        return this.avgReadTime;
    }

    public long getWrites() {
        return this.writes;
    }

    public long getHits() {
        return this.hits;
    }

    public long getMisses() {
        return this.misses;
    }

    public long getTxCommits() {
        return this.txCommits;
    }

    public float getAvgTxCommitTime() {
        return this.avgTxCommitTime;
    }

    public float getAvgTxRollbackTime() {
        return this.avgTxRollbackTime;
    }

    public long getPuts() {
        return this.puts;
    }

    public float getAvgPutTime() {
        return this.avgPutTime;
    }

    public long getRemovals() {
        return this.removals;
    }

    public float getAvgRemovalTime() {
        return this.avgRemovalTime;
    }

    public long getEvictions() {
        return this.evictions;
    }

    public long getTxRollbacks() {
        return this.txRollbacks;
    }

    public int getReadsPerSecond() {
        return this.readsPerSec;
    }

    public int getPutsPerSecond() {
        return this.putsPerSec;
    }

    public int getRemovalsPerSecond() {
        return this.removalsPerSec;
    }

    public int getCommitsPerSecond() {
        return this.commitsPerSec;
    }

    public int getRollbacksPerSecond() {
        return this.rollbacksPerSec;
    }

    public int getSize() {
        return this.size;
    }

    public int getKeySize() {
        return this.keySize;
    }

    public long getCacheSize() {
        return this.cacheSize;
    }

    public VisorQueryMetrics getQueryMetrics() {
        return this.qryMetrics;
    }

    public int getDhtEvictQueueCurrentSize() {
        return this.dhtEvictQueueCurrSize;
    }

    public int getTxThreadMapSize() {
        return this.txThreadMapSize;
    }

    public int getTxXidMapSize() {
        return this.txXidMapSize;
    }

    public int getTxCommitQueueSize() {
        return this.txCommitQueueSize;
    }

    public int getTxPrepareQueueSize() {
        return this.txPrepareQueueSize;
    }

    public int getTxStartVersionCountsSize() {
        return this.txStartVerCountsSize;
    }

    public int getTxCommittedVersionsSize() {
        return this.txCommittedVersionsSize;
    }

    public int getTxRolledbackVersionsSize() {
        return this.txRolledbackVersionsSize;
    }

    public int getTxDhtThreadMapSize() {
        return this.txDhtThreadMapSize;
    }

    public int getTxDhtXidMapSize() {
        return this.txDhtXidMapSize;
    }

    public int getTxDhtCommitQueueSize() {
        return this.txDhtCommitQueueSize;
    }

    public int getTxDhtPrepareQueueSize() {
        return this.txDhtPrepareQueueSize;
    }

    public int getTxDhtStartVersionCountsSize() {
        return this.txDhtStartVerCountsSize;
    }

    public int getTxDhtCommittedVersionsSize() {
        return this.txDhtCommittedVersionsSize;
    }

    public int getTxDhtRolledbackVersionsSize() {
        return this.txDhtRolledbackVersionsSize;
    }

    public long getHeapEntriesCount() {
        return this.heapEntriesCnt;
    }

    public long getOffHeapAllocatedSize() {
        return this.offHeapAllocatedSize;
    }

    public long getOffHeapEntriesCount() {
        return this.offHeapEntriesCnt;
    }

    public long getOffHeapPrimaryEntriesCount() {
        return this.offHeapPrimaryEntriesCnt;
    }

    public long getOffHeapBackupEntriesCount() {
        return this.offHeapEntriesCnt - this.offHeapPrimaryEntriesCnt;
    }

    public int getTotalPartitionsCount() {
        return this.totalPartsCnt;
    }

    public long getRebalancedKeys() {
        return this.rebalancedKeys;
    }

    public long getEstimatedRebalancingKeys() {
        return this.estimatedRebalancingKeys;
    }

    public int getRebalancingPartitionsCount() {
        return this.rebalancingPartsCnt;
    }

    public long getKeysToRebalanceLeft() {
        return this.keysToRebalanceLeft;
    }

    public long getRebalancingKeysRate() {
        return this.rebalancingKeysRate;
    }

    public long getRebalancingBytesRate() {
        return this.rebalancingBytesRate;
    }

    @Override
    public byte getProtocolVersion() {
        return 2;
    }

    @Override
    protected void writeExternalData(ObjectOutput out) throws IOException {
        U.writeString(out, this.name);
        U.writeEnum(out, this.mode);
        out.writeBoolean(this.sys);
        out.writeInt(this.size);
        out.writeInt(this.keySize);
        out.writeLong(this.reads);
        out.writeFloat(this.avgReadTime);
        out.writeLong(this.writes);
        out.writeLong(this.hits);
        out.writeLong(this.misses);
        out.writeLong(this.txCommits);
        out.writeFloat(this.avgTxCommitTime);
        out.writeLong(this.txRollbacks);
        out.writeFloat(this.avgTxRollbackTime);
        out.writeLong(this.puts);
        out.writeFloat(this.avgPutTime);
        out.writeLong(this.removals);
        out.writeFloat(this.avgRemovalTime);
        out.writeLong(this.evictions);
        out.writeInt(this.readsPerSec);
        out.writeInt(this.putsPerSec);
        out.writeInt(this.removalsPerSec);
        out.writeInt(this.commitsPerSec);
        out.writeInt(this.rollbacksPerSec);
        out.writeInt(this.dhtEvictQueueCurrSize);
        out.writeInt(this.txThreadMapSize);
        out.writeInt(this.txXidMapSize);
        out.writeInt(this.txCommitQueueSize);
        out.writeInt(this.txPrepareQueueSize);
        out.writeInt(this.txStartVerCountsSize);
        out.writeInt(this.txCommittedVersionsSize);
        out.writeInt(this.txRolledbackVersionsSize);
        out.writeInt(this.txDhtThreadMapSize);
        out.writeInt(this.txDhtXidMapSize);
        out.writeInt(this.txDhtCommitQueueSize);
        out.writeInt(this.txDhtPrepareQueueSize);
        out.writeInt(this.txDhtStartVerCountsSize);
        out.writeInt(this.txDhtCommittedVersionsSize);
        out.writeInt(this.txDhtRolledbackVersionsSize);
        out.writeLong(this.heapEntriesCnt);
        out.writeLong(this.offHeapAllocatedSize);
        out.writeLong(this.offHeapEntriesCnt);
        out.writeLong(this.offHeapPrimaryEntriesCnt);
        out.writeInt(this.totalPartsCnt);
        out.writeInt(this.rebalancingPartsCnt);
        out.writeLong(this.keysToRebalanceLeft);
        out.writeLong(this.rebalancingKeysRate);
        out.writeLong(this.rebalancingBytesRate);
        out.writeObject(this.qryMetrics);
        out.writeLong(this.cacheSize);
        out.writeLong(this.rebalancedKeys);
        out.writeLong(this.estimatedRebalancingKeys);
    }

    @Override
    protected void readExternalData(byte protoVer, ObjectInput in) throws IOException, ClassNotFoundException {
        this.name = U.readString(in);
        this.mode = CacheMode.fromOrdinal(in.readByte());
        this.sys = in.readBoolean();
        this.size = in.readInt();
        this.keySize = in.readInt();
        this.reads = in.readLong();
        this.avgReadTime = in.readFloat();
        this.writes = in.readLong();
        this.hits = in.readLong();
        this.misses = in.readLong();
        this.txCommits = in.readLong();
        this.avgTxCommitTime = in.readFloat();
        this.txRollbacks = in.readLong();
        this.avgTxRollbackTime = in.readFloat();
        this.puts = in.readLong();
        this.avgPutTime = in.readFloat();
        this.removals = in.readLong();
        this.avgRemovalTime = in.readFloat();
        this.evictions = in.readLong();
        this.readsPerSec = in.readInt();
        this.putsPerSec = in.readInt();
        this.removalsPerSec = in.readInt();
        this.commitsPerSec = in.readInt();
        this.rollbacksPerSec = in.readInt();
        this.dhtEvictQueueCurrSize = in.readInt();
        this.txThreadMapSize = in.readInt();
        this.txXidMapSize = in.readInt();
        this.txCommitQueueSize = in.readInt();
        this.txPrepareQueueSize = in.readInt();
        this.txStartVerCountsSize = in.readInt();
        this.txCommittedVersionsSize = in.readInt();
        this.txRolledbackVersionsSize = in.readInt();
        this.txDhtThreadMapSize = in.readInt();
        this.txDhtXidMapSize = in.readInt();
        this.txDhtCommitQueueSize = in.readInt();
        this.txDhtPrepareQueueSize = in.readInt();
        this.txDhtStartVerCountsSize = in.readInt();
        this.txDhtCommittedVersionsSize = in.readInt();
        this.txDhtRolledbackVersionsSize = in.readInt();
        this.heapEntriesCnt = in.readLong();
        this.offHeapAllocatedSize = in.readLong();
        this.offHeapEntriesCnt = in.readLong();
        this.offHeapPrimaryEntriesCnt = in.readLong();
        this.totalPartsCnt = in.readInt();
        this.rebalancingPartsCnt = in.readInt();
        this.keysToRebalanceLeft = in.readLong();
        this.rebalancingKeysRate = in.readLong();
        this.rebalancingBytesRate = in.readLong();
        this.qryMetrics = (VisorQueryMetrics)in.readObject();
        if (in.available() > 0) {
            this.cacheSize = in.readLong();
        }
        if (protoVer > 1) {
            this.rebalancedKeys = in.readLong();
            this.estimatedRebalancingKeys = in.readLong();
        }
    }

    public String toString() {
        return S.toString(VisorCacheMetrics.class, this);
    }
}

