/*
 * Decompiled with CFR 0.152.
 */
package org.netcrusher.core.main;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetSocketAddress;
import org.netcrusher.NetCrusher;
import org.netcrusher.core.nio.NioUtils;
import org.netcrusher.core.reactor.NioReactor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractCrusherMain<T extends NetCrusher> {
    protected static final Logger LOGGER = LoggerFactory.getLogger(AbstractCrusherMain.class);
    private static final int ERR_EXIT_CODE_NO_ARGUMENT = 1;
    private static final int ERR_EXIT_CODE_INVALID_ADDRESS = 2;
    private static final int ERR_EXIT_INITIALIZATION = 3;
    private static final String CMD_OPEN = "OPEN";
    private static final String CMD_CLOSE = "CLOSE";
    private static final String CMD_REOPEN = "REOPEN";
    private static final String CMD_FREEZE = "FREEZE";
    private static final String CMD_UNFREEZE = "UNFREEZE";
    private static final String CMD_STATUS = "STATUS";
    private static final String CMD_HELP = "HELP";
    private static final String CMD_QUIT = "QUIT";
    private static final String CMD_CLIENT_CLOSE = "CLIENT-CLOSE";
    private static final String CMD_CLIENT_STATUS = "CLIENT-STATUS";

    protected int run(String[] arguments) {
        InetSocketAddress connectAddress;
        InetSocketAddress bindAddress;
        if (arguments == null || arguments.length != 2) {
            this.printUsage();
            return 1;
        }
        try {
            bindAddress = NioUtils.parseInetSocketAddress(arguments[0]);
        }
        catch (IllegalArgumentException e) {
            LOGGER.error("Fail to parse listening address: {}", (Object)arguments[0], (Object)e);
            return 2;
        }
        try {
            connectAddress = NioUtils.parseInetSocketAddress(arguments[1]);
        }
        catch (IllegalArgumentException e) {
            LOGGER.error("Fail to parse connect address: {}", (Object)arguments[1], (Object)e);
            return 2;
        }
        long tickMs = Integer.getInteger("crusher.tick", 10).intValue();
        LOGGER.debug("Reactor tick = {} ms", (Object)tickMs);
        return this.run(bindAddress, connectAddress, tickMs);
    }

    protected int run(InetSocketAddress bindAddress, InetSocketAddress connectAddress, long tickMs) {
        String javaVersion;
        T crusher;
        NioReactor reactor;
        try {
            reactor = new NioReactor(tickMs);
        }
        catch (Exception e) {
            LOGGER.error("Fail to create reactor", e);
            return 3;
        }
        try {
            crusher = this.create(reactor, bindAddress, connectAddress);
        }
        catch (Exception e) {
            LOGGER.error("Fail to create crusher", e);
            reactor.close();
            return 3;
        }
        Runnable closer = () -> {
            try {
                if (crusher.isOpen()) {
                    this.close(crusher);
                }
            }
            catch (Exception e) {
                LOGGER.error("Fail to close the crusher", e);
            }
            try {
                if (reactor.isOpen()) {
                    reactor.close();
                }
            }
            catch (Exception e) {
                LOGGER.error("Fail to close the reactor", e);
            }
        };
        Runtime.getRuntime().addShutdownHook(new Thread(closer));
        String crusherVersion = this.getClass().getPackage().getImplementationVersion();
        if (crusherVersion != null && !crusherVersion.isEmpty()) {
            System.out.printf("# Version: %s\n", crusherVersion);
        }
        if ((javaVersion = System.getProperty("java.version")) != null && !javaVersion.isEmpty()) {
            System.out.printf("# Java: %s\n", javaVersion);
        }
        System.out.println("# Print `HELP` for the list of the commands");
        this.repl(crusher);
        closer.run();
        LOGGER.info("Exiting..");
        return 0;
    }

    protected void repl(T crusher) {
        block33: {
            try (InputStreamReader isr = new InputStreamReader(System.in);){
                BufferedReader br = new BufferedReader(isr);
                Throwable throwable = null;
                block22: while (true) {
                    try {
                        while (true) {
                            System.out.printf("# enter the command in the next line (crusher is %s)\n", crusher.isOpen() ? CMD_OPEN : "CLOSED");
                            String line = br.readLine();
                            if (line == null) {
                                break block33;
                            }
                            if (line.isEmpty()) {
                                LOGGER.warn("Command is empty");
                                continue;
                            }
                            if (CMD_QUIT.equals(line)) {
                                break block33;
                            }
                            try {
                                this.command(crusher, line);
                                continue block22;
                            }
                            catch (Exception e) {
                                LOGGER.error("Command failed: '{}'", (Object)line, (Object)e);
                                continue;
                            }
                            break;
                        }
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                }
                finally {
                    if (br != null) {
                        if (throwable != null) {
                            try {
                                br.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        } else {
                            br.close();
                        }
                    }
                }
            }
            catch (IOException e) {
                LOGGER.error("REPL error", e);
            }
        }
    }

    protected void command(T crusher, String command) {
        if (command.equals(CMD_OPEN)) {
            this.open(crusher);
        } else if (command.equals(CMD_CLOSE)) {
            this.close(crusher);
        } else if (command.equals(CMD_REOPEN)) {
            this.reopen(crusher);
        } else if (command.equals(CMD_STATUS)) {
            this.status(crusher);
        } else if (command.equals(CMD_FREEZE)) {
            this.freeze(crusher);
        } else if (command.equals(CMD_UNFREEZE)) {
            this.unfreeze(crusher);
        } else if (command.equals(CMD_HELP)) {
            this.printHelp();
        } else if (command.startsWith(CMD_CLIENT_CLOSE)) {
            this.closeClient(crusher, command);
        } else if (command.startsWith(CMD_CLIENT_STATUS)) {
            this.statusClient(crusher, command);
        } else {
            LOGGER.warn("Command is unknown: '{}'", (Object)command);
        }
    }

    protected void open(T crusher) {
        if (crusher.isOpen()) {
            LOGGER.warn("Crusher is already open");
        } else {
            crusher.open();
            LOGGER.info("Crusher is open");
        }
    }

    protected void close(T crusher) {
        if (crusher.isOpen()) {
            crusher.close();
            LOGGER.info("Crusher is closed");
        } else {
            LOGGER.warn("Crusher is not open");
        }
    }

    protected void reopen(T crusher) {
        if (crusher.isOpen()) {
            crusher.reopen();
            LOGGER.info("Crusher is reopen");
        } else {
            LOGGER.warn("Crusher is not open");
        }
    }

    protected void freeze(T crusher) {
        if (crusher.isOpen()) {
            crusher.freeze();
            LOGGER.info("Crusher is frozen");
        } else {
            LOGGER.warn("Crusher is not open");
        }
    }

    protected void unfreeze(T crusher) {
        if (crusher.isOpen()) {
            crusher.unfreeze();
            LOGGER.info("Crusher is unfrozen");
        } else {
            LOGGER.warn("Crusher is not open");
        }
    }

    protected void status(T crusher) {
        LOGGER.info("{} crusher for <{}>-<{}>", crusher.getClass().getSimpleName(), crusher.getBindAddress(), crusher.getConnectAddress());
        if (crusher.isOpen()) {
            LOGGER.info("Crusher is open");
            if (crusher.isFrozen()) {
                LOGGER.info("Crusher is frozen");
            }
            LOGGER.info("Total number of registered clients: {}", (Object)crusher.getClientTotalCount());
            LOGGER.info("Total number of active clients: {}", (Object)crusher.getClientAddresses().size());
            for (InetSocketAddress clientAddress : crusher.getClientAddresses()) {
                this.statusClient(crusher, clientAddress);
            }
        } else {
            LOGGER.info("Crusher is closed");
        }
    }

    protected void closeClient(T crusher, String command) {
        InetSocketAddress address = AbstractCrusherMain.parseAddress(command);
        boolean closed = crusher.closeClient(address);
        if (closed) {
            LOGGER.info("Client for <{}> is closed", (Object)address);
        } else {
            LOGGER.warn("Client for <{}> is not found", (Object)address);
        }
    }

    protected void statusClient(T crusher, String command) {
        InetSocketAddress address = AbstractCrusherMain.parseAddress(command);
        this.statusClient(crusher, address);
    }

    protected void statusClient(T crusher, InetSocketAddress address) {
        LOGGER.info("Client address <{}>", (Object)address);
    }

    protected void printUsage() {
        LOGGER.warn("Execution: {} <bind-socket-address:port> <connect-socket-address:port>", (Object)this.getClass().getSimpleName());
    }

    protected void printHelp() {
        LOGGER.info("Commands:");
        LOGGER.info("\tOPEN     - opens the crusher");
        LOGGER.info("\tCLOSE    - closes the crusher (sockets will be closed)");
        LOGGER.info("\tREOPEN   - closes and opens the crusher again");
        LOGGER.info("\tFREEZE   - freezes the crusher (socket are open but data is not transferred)");
        LOGGER.info("\tUNFREEZE - unfreezes the crusher");
        LOGGER.info("\tSTATUS   - prints the status of the connection");
        LOGGER.info("\tHELP     - prints this help");
        LOGGER.info("\tQUIT     - quits the program");
        LOGGER.info("Commands for clients:");
        LOGGER.info("\tCLIENT-CLOSE <addr>    - closes the client");
        LOGGER.info("\tCLIENT-STATUS <addr>   - prints status of the client");
    }

    protected static InetSocketAddress parseAddress(String command) {
        String[] items = command.split(" ", 2);
        if (items.length == 2) {
            return NioUtils.parseInetSocketAddress(items[1]);
        }
        throw new IllegalArgumentException("Fail to parse address from command: " + command);
    }

    protected abstract T create(NioReactor var1, InetSocketAddress var2, InetSocketAddress var3);
}

