/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.util.test;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class GridTestPrintStream
extends PrintStream {
    private final Map<ThreadGroup, BytePrintStream> streams = new HashMap<ThreadGroup, BytePrintStream>();
    private final ThreadGroup baseGrp;

    public GridTestPrintStream(PrintStream out) {
        super(out);
        this.baseGrp = Thread.currentThread().getThreadGroup().getParent();
    }

    public GridTestPrintStream(PrintStream out, ThreadGroup baseGrp) {
        super(out);
        assert (baseGrp != null);
        this.baseGrp = baseGrp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BytePrintStream out(boolean release) {
        Map<ThreadGroup, BytePrintStream> map = this.streams;
        synchronized (map) {
            BytePrintStream out;
            ThreadGroup grp;
            for (grp = Thread.currentThread().getThreadGroup(); grp != null && grp.getParent() != this.baseGrp; grp = grp.getParent()) {
            }
            BytePrintStream bytePrintStream = out = release ? this.streams.remove(grp) : this.streams.get(grp);
            if (out == null) {
                if (release) {
                    return new BytePrintStream();
                }
                out = new BytePrintStream();
                this.streams.put(grp, out);
            }
            return out;
        }
    }

    public void purge() throws IOException {
        this.out(true).writeTo(this.out);
    }

    public void purge(OutputStream out) throws IOException {
        this.out(true).writeTo(out);
    }

    @Override
    public void println() {
        this.out(false).println();
    }

    @Override
    public void print(char c) {
        this.out(false).print(c);
    }

    @Override
    public void println(char x) {
        this.out(false).println(x);
    }

    @Override
    public void print(double d) {
        this.out(false).print(d);
    }

    @Override
    public void println(double x) {
        this.out(false).println(x);
    }

    @Override
    public void print(float f) {
        this.out(false).print(f);
    }

    @Override
    public void println(float x) {
        this.out(false).println(x);
    }

    @Override
    public void print(int i) {
        this.out(false).print(i);
    }

    @Override
    public void println(int x) {
        this.out(false).println(x);
    }

    @Override
    public void print(long l) {
        this.out(false).print(l);
    }

    @Override
    public void println(long x) {
        this.out(false).println(x);
    }

    @Override
    public void print(boolean b) {
        this.out(false).print(b);
    }

    @Override
    public void println(boolean x) {
        this.out(false).println(x);
    }

    @Override
    public void print(char[] s) {
        this.out(false).print(s);
    }

    @Override
    public void println(char[] x) {
        this.out(false).println(x);
    }

    @Override
    public void print(Object obj) {
        this.out(false).print(obj);
    }

    @Override
    public void println(Object x) {
        this.out(false).println(x);
    }

    @Override
    public void print(String s) {
        this.out(false).print(s);
    }

    @Override
    public void println(String x) {
        this.out(false).println(x);
    }

    @Override
    public void write(byte[] buf, int off, int len) {
        this.out(false).write(buf, off, len);
    }

    @Override
    public void close() {
        this.out(false).close();
    }

    @Override
    public void flush() {
        this.out(false).flush();
    }

    @Override
    public void write(int b) {
        this.out(false).write(b);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.out(false).write(b);
    }

    @Override
    public PrintStream append(CharSequence csq) {
        return this.out(false).append(csq);
    }

    @Override
    public PrintStream append(CharSequence csq, int start, int end) {
        return this.out(false).append(csq, start, end);
    }

    @Override
    public PrintStream append(char c) {
        return this.out(false).append(c);
    }

    @Override
    public PrintStream printf(String format, Object ... args) {
        return this.out(false).printf(format, args);
    }

    @Override
    public PrintStream printf(Locale l, String format, Object ... args) {
        return this.out(false).printf(l, format, args);
    }

    @Override
    public PrintStream format(String format, Object ... args) {
        return this.out(false).format(format, args);
    }

    @Override
    public PrintStream format(Locale l, String format, Object ... args) {
        return this.out(false).format(l, format, args);
    }

    private static class BytePrintStream
    extends PrintStream {
        BytePrintStream() {
            super(new ByteArrayOutputStream());
        }

        void writeTo(OutputStream out) throws IOException {
            this.flush();
            ByteArrayOutputStream byteOut = (ByteArrayOutputStream)this.out;
            byteOut.writeTo(out);
            byteOut.reset();
        }
    }
}

