/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.angela.agent.com;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteInterruptedException;
import org.apache.ignite.cluster.ClusterGroupEmptyException;
import org.apache.ignite.lang.IgniteFuture;
import org.apache.ignite.lang.IgniteFutureTimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.angela.agent.com.AgentID;

public class IgniteFutureAdapter<V>
implements Future<V> {
    private static final Logger logger = LoggerFactory.getLogger(IgniteFutureAdapter.class);
    private final AgentID agentID;
    private final IgniteFuture<V> igniteFuture;

    public IgniteFutureAdapter(AgentID agentID, IgniteFuture<V> igniteFuture) {
        this.agentID = agentID;
        this.igniteFuture = igniteFuture;
    }

    public AgentID getAgentID() {
        return this.agentID;
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        return this.igniteFuture.cancel();
    }

    @Override
    public boolean isCancelled() {
        return this.igniteFuture.isCancelled();
    }

    @Override
    public boolean isDone() {
        return this.igniteFuture.isDone();
    }

    @Override
    public V get() throws InterruptedException, ExecutionException {
        try {
            return this.igniteFuture.get();
        }
        catch (ClusterGroupEmptyException cge) {
            logger.warn("DETECTED POTENTIAL UNEXPECTED FAILURE (OR KILL) OF JVM WITH NODE: {}", (Object)this.agentID);
            throw new IllegalStateException("Agent is gone in an abrupt way and Ignite cannot get any result from it anymore: " + this.agentID, cge);
        }
        catch (IgniteInterruptedException iie) {
            throw (InterruptedException)new InterruptedException().initCause(iie);
        }
        catch (IgniteException ie) {
            RemoteExecutionException ree = IgniteFutureAdapter.lookForRemoteExecutionException(ie);
            if (ree != null) {
                throw new ExecutionException("Job execution failed on agent: " + this.agentID, ree);
            }
            throw new ExecutionException("Job execution failed on agent: " + this.agentID, ie);
        }
    }

    @Override
    public V get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        try {
            return this.igniteFuture.get(timeout, unit);
        }
        catch (ClusterGroupEmptyException cge) {
            logger.warn("DETECTED POTENTIAL UNEXPECTED FAILURE (OR KILL) OF JVM WITH NODE: {}", (Object)this.agentID);
            throw new IllegalStateException("Agent is gone in an abrupt way and Ignite cannot get any result from it anymore: " + this.agentID, cge);
        }
        catch (IgniteInterruptedException iie) {
            throw (InterruptedException)new InterruptedException().initCause(iie);
        }
        catch (IgniteFutureTimeoutException ifte) {
            throw (TimeoutException)new TimeoutException().initCause(ifte);
        }
        catch (IgniteException ie) {
            RemoteExecutionException ree = IgniteFutureAdapter.lookForRemoteExecutionException(ie);
            if (ree != null) {
                throw new ExecutionException("Job execution failed on agent: " + this.agentID, ree);
            }
            throw new ExecutionException("Job execution failed on agent: " + this.agentID, ie);
        }
    }

    private static RemoteExecutionException lookForRemoteExecutionException(Throwable t) {
        if (t instanceof RemoteExecutionException) {
            return (RemoteExecutionException)t;
        }
        if (t == null) {
            return null;
        }
        return IgniteFutureAdapter.lookForRemoteExecutionException(t.getCause());
    }

    public static class RemoteExecutionException
    extends Exception {
        private static final long serialVersionUID = 1L;
        private final String remoteStackTrace;
        private String tabulation = "\t";

        public RemoteExecutionException(String message, String remoteStackTrace) {
            super(message);
            this.remoteStackTrace = remoteStackTrace;
        }

        @Override
        public String getMessage() {
            return super.getMessage() + "; Remote stack trace is:" + System.lineSeparator() + this.tabulation + "{{{" + System.lineSeparator() + this.tabulation + this.remoteStackTrace() + "}}}";
        }

        private String remoteStackTrace() {
            return this.remoteStackTrace.replaceAll(System.lineSeparator(), System.lineSeparator() + this.tabulation);
        }

        public void setRemoteStackTraceIndentation(int indentation) {
            StringBuilder sb = new StringBuilder(indentation);
            for (int i = 0; i < indentation; ++i) {
                sb.append('\t');
            }
            this.tabulation = sb.toString();
        }
    }
}

