/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.visor.consistency;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.compute.ComputeJobResult;
import org.apache.ignite.internal.visor.VisorJob;
import org.apache.ignite.internal.visor.consistency.AbstractConsistencyTask;
import org.apache.ignite.internal.visor.consistency.VisorConsistencyTaskResult;
import org.apache.ignite.resources.LoggerResource;

public class VisorConsistencyStatusTask
extends AbstractConsistencyTask<Void, String> {
    private static final long serialVersionUID = 0L;
    public static final String NOTHING_FOUND = "Consistency check/repair operations were NOT found.";
    public static final ConcurrentHashMap<String, String> MAP = new ConcurrentHashMap();

    @Override
    protected VisorJob<Void, String> job(Void arg) {
        return new VisorConsistencyStatusJob(arg, this.debug);
    }

    @Override
    protected VisorConsistencyTaskResult reduce0(List<ComputeJobResult> results) throws IgniteException {
        Object taskRes = super.reduce0((List)results);
        if (((VisorConsistencyTaskResult)taskRes).message() == null) {
            ((VisorConsistencyTaskResult)taskRes).message(NOTHING_FOUND);
        }
        return taskRes;
    }

    private static class VisorConsistencyStatusJob
    extends VisorJob<Void, String> {
        private static final long serialVersionUID = 0L;
        @LoggerResource
        protected IgniteLogger log;

        protected VisorConsistencyStatusJob(Void arg, boolean debug) {
            super(arg, debug);
        }

        @Override
        protected String run(Void arg) throws IgniteException {
            if (MAP.isEmpty()) {
                return null;
            }
            StringBuilder sb = new StringBuilder();
            for (Map.Entry<String, String> entry : MAP.entrySet()) {
                sb.append("\n    Job: ").append(entry.getKey()).append("\n").append("    Status: ").append(entry.getValue()).append("\n");
            }
            return sb.toString();
        }
    }
}

