/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence.tree.util;

import java.nio.ByteBuffer;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.metric.IoStatisticsHolder;
import org.apache.ignite.internal.pagemem.PageMemory;
import org.apache.ignite.internal.pagemem.PageSupport;
import org.apache.ignite.internal.pagemem.wal.IgniteWriteAheadLogManager;
import org.apache.ignite.internal.pagemem.wal.record.delta.InitNewPageRecord;
import org.apache.ignite.internal.processors.cache.persistence.pagemem.PageMetrics;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.PageIO;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.PageIoResolver;
import org.apache.ignite.internal.processors.cache.persistence.tree.util.PageLockListener;
import org.apache.ignite.internal.util.GridUnsafe;
import org.jetbrains.annotations.Nullable;

public abstract class PageHandler<X, R> {
    private static final PageHandler<Void, Boolean> NO_OP = new PageHandler<Void, Boolean>(){

        @Override
        public Boolean run(int cacheId, long pageId, long page, long pageAddr, PageIO io, Boolean walPlc, Void arg, int intArg, IoStatisticsHolder statHolder) throws IgniteCheckedException {
            return Boolean.TRUE;
        }
    };

    public abstract R run(int var1, long var2, long var4, long var6, PageIO var8, Boolean var9, X var10, int var11, IoStatisticsHolder var12) throws IgniteCheckedException;

    public boolean releaseAfterWrite(int cacheId, long pageId, long page, long pageAddr, X arg, int intArg) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <X, R> R readPage(PageMemory pageMem, int cacheId, long pageId, PageLockListener lsnr, PageHandler<X, R> h, X arg, int intArg, R lockFailed, IoStatisticsHolder statHolder, PageIoResolver pageIoRslvr) throws IgniteCheckedException {
        long page = pageMem.acquirePage(cacheId, pageId, statHolder);
        try {
            R r;
            long pageAddr = PageHandler.readLock(pageMem, cacheId, pageId, page, lsnr);
            if (pageAddr == 0L) {
                R r2 = lockFailed;
                return r2;
            }
            try {
                PageIO io = pageIoRslvr.resolve(pageAddr);
                r = h.run(cacheId, pageId, page, pageAddr, io, null, arg, intArg, statHolder);
            }
            catch (Throwable throwable) {
                PageHandler.readUnlock(pageMem, cacheId, pageId, page, pageAddr, lsnr);
                throw throwable;
            }
            PageHandler.readUnlock(pageMem, cacheId, pageId, page, pageAddr, lsnr);
            return r;
        }
        finally {
            pageMem.releasePage(cacheId, pageId, page);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <X, R> R readPage(PageMemory pageMem, int cacheId, long pageId, long page, PageLockListener lsnr, PageHandler<X, R> h, X arg, int intArg, R lockFailed, IoStatisticsHolder statHolder, PageIoResolver pageIoRslvr) throws IgniteCheckedException {
        long pageAddr = 0L;
        try {
            pageAddr = PageHandler.readLock(pageMem, cacheId, pageId, page, lsnr);
            if (pageAddr == 0L) {
                R r = lockFailed;
                return r;
            }
            PageIO io = pageIoRslvr.resolve(pageAddr);
            R r = h.run(cacheId, pageId, page, pageAddr, io, null, arg, intArg, statHolder);
            return r;
        }
        finally {
            if (pageAddr != 0L) {
                PageHandler.readUnlock(pageMem, cacheId, pageId, page, pageAddr, lsnr);
            }
        }
    }

    public static long readLock(PageMemory pageMem, int cacheId, long pageId, long page, PageLockListener lsnr) {
        lsnr.onBeforeReadLock(cacheId, pageId, page);
        long pageAddr = pageMem.readLock(cacheId, pageId, page);
        lsnr.onReadLock(cacheId, pageId, page, pageAddr);
        return pageAddr;
    }

    public static void readUnlock(PageMemory pageMem, int cacheId, long pageId, long page, long pageAddr, PageLockListener lsnr) {
        lsnr.onReadUnlock(cacheId, pageId, page, pageAddr);
        pageMem.readUnlock(cacheId, pageId, page);
    }

    public static void initPage(PageMemory pageMem, int grpId, long pageId, PageIO init, IgniteWriteAheadLogManager wal, PageLockListener lsnr, IoStatisticsHolder statHolder) throws IgniteCheckedException {
        Boolean res = PageHandler.writePage(pageMem, grpId, pageId, lsnr, NO_OP, init, wal, null, null, 0, Boolean.FALSE, statHolder, PageIoResolver.DEFAULT_PAGE_IO_RESOLVER);
        assert (res != Boolean.FALSE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <X, R> R writePage(PageMemory pageMem, int grpId, long pageId, PageLockListener lsnr, PageHandler<X, R> h, PageIO init, IgniteWriteAheadLogManager wal, Boolean walPlc, X arg, int intArg, R lockFailed, IoStatisticsHolder statHolder, PageIoResolver pageIoRslvr) throws IgniteCheckedException {
        boolean releaseAfterWrite = true;
        long page = pageMem.acquirePage(grpId, pageId, statHolder);
        try {
            R r;
            long pageAddr = PageHandler.writeLock(pageMem, grpId, pageId, page, lsnr, false);
            if (pageAddr == 0L) {
                R r2 = lockFailed;
                return r2;
            }
            boolean ok = false;
            try {
                if (init != null) {
                    PageHandler.doInitPage(pageMem, grpId, pageId, page, pageAddr, init, wal);
                    walPlc = Boolean.FALSE;
                } else {
                    init = pageIoRslvr.resolve(pageAddr);
                }
                R res = h.run(grpId, pageId, page, pageAddr, init, walPlc, arg, intArg, statHolder);
                ok = true;
                r = res;
            }
            catch (Throwable throwable) {
                assert (PageIO.getCrc(pageAddr) == 0);
                releaseAfterWrite = h.releaseAfterWrite(grpId, pageId, page, pageAddr, arg, intArg);
                if (releaseAfterWrite) {
                    PageHandler.writeUnlock(pageMem, grpId, pageId, page, pageAddr, lsnr, walPlc, ok);
                }
                throw throwable;
            }
            assert (PageIO.getCrc(pageAddr) == 0);
            releaseAfterWrite = h.releaseAfterWrite(grpId, pageId, page, pageAddr, arg, intArg);
            if (releaseAfterWrite) {
                PageHandler.writeUnlock(pageMem, grpId, pageId, page, pageAddr, lsnr, walPlc, ok);
            }
            return r;
        }
        finally {
            if (releaseAfterWrite) {
                pageMem.releasePage(grpId, pageId, page);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <X, R> R writePage(PageMemory pageMem, int grpId, long pageId, long page, PageLockListener lsnr, PageHandler<X, R> h, PageIO init, IgniteWriteAheadLogManager wal, Boolean walPlc, X arg, int intArg, R lockFailed, IoStatisticsHolder statHolder, PageIoResolver pageIoRslvr) throws IgniteCheckedException {
        long pageAddr = PageHandler.writeLock(pageMem, grpId, pageId, page, lsnr, false);
        if (pageAddr == 0L) {
            return lockFailed;
        }
        boolean ok = false;
        try {
            if (init != null) {
                PageHandler.doInitPage(pageMem, grpId, pageId, page, pageAddr, init, wal);
                walPlc = Boolean.FALSE;
            } else {
                init = pageIoRslvr.resolve(pageAddr);
            }
            R res = h.run(grpId, pageId, page, pageAddr, init, walPlc, arg, intArg, statHolder);
            ok = true;
            R r = res;
            return r;
        }
        finally {
            assert (PageIO.getCrc(pageAddr) == 0);
            if (h.releaseAfterWrite(grpId, pageId, page, pageAddr, arg, intArg)) {
                PageHandler.writeUnlock(pageMem, grpId, pageId, page, pageAddr, lsnr, walPlc, ok);
            }
        }
    }

    public static void writeUnlock(PageMemory pageMem, int cacheId, long pageId, long page, long pageAddr, PageLockListener lsnr, Boolean walPlc, boolean dirty) {
        lsnr.onWriteUnlock(cacheId, pageId, page, pageAddr);
        pageMem.writeUnlock(cacheId, pageId, page, walPlc, dirty);
    }

    public static long writeLock(PageMemory pageMem, int cacheId, long pageId, long page, PageLockListener lsnr, boolean tryLock) {
        lsnr.onBeforeWriteLock(cacheId, pageId, page);
        long pageAddr = tryLock ? pageMem.tryWriteLock(cacheId, pageId, page) : pageMem.writeLock(cacheId, pageId, page);
        lsnr.onWriteLock(cacheId, pageId, page, pageAddr);
        return pageAddr;
    }

    private static void doInitPage(PageMemory pageMem, int grpId, long pageId, long page, long pageAddr, PageIO init, IgniteWriteAheadLogManager wal) throws IgniteCheckedException {
        assert (PageIO.getCrc(pageAddr) == 0);
        PageMetrics metrics = pageMem.metrics().cacheGrpPageMetrics(grpId);
        init.initNewPage(pageAddr, pageId, pageMem.realPageSize(grpId), metrics);
        if (PageHandler.isWalDeltaRecordNeeded(pageMem, grpId, pageId, page, wal, Boolean.FALSE)) {
            wal.log(new InitNewPageRecord(grpId, pageId, init.getType(), init.getVersion(), pageId));
        }
    }

    public static boolean isWalDeltaRecordNeeded(PageSupport pageMem, int cacheId, long pageId, long page, IgniteWriteAheadLogManager wal, @Nullable Boolean walPlc) {
        return wal != null && !wal.isAlwaysWriteFullPages() && walPlc != Boolean.TRUE && !wal.disabled(cacheId, pageId) && (walPlc == Boolean.FALSE || pageMem.isDirty(cacheId, pageId, page));
    }

    public static void copyMemory(ByteBuffer src, long srcOff, ByteBuffer dst, long dstOff, long cnt) {
        byte[] srcArr = src.hasArray() ? src.array() : null;
        byte[] dstArr = dst.hasArray() ? dst.array() : null;
        long srcArrOff = src.hasArray() ? (long)src.arrayOffset() + GridUnsafe.BYTE_ARR_OFF : 0L;
        long dstArrOff = dst.hasArray() ? (long)dst.arrayOffset() + GridUnsafe.BYTE_ARR_OFF : 0L;
        long srcPtr = src.isDirect() ? GridUnsafe.bufferAddress(src) : 0L;
        long dstPtr = dst.isDirect() ? GridUnsafe.bufferAddress(dst) : 0L;
        GridUnsafe.copyMemory(srcArr, srcPtr + srcArrOff + srcOff, dstArr, dstPtr + dstArrOff + dstOff, cnt);
    }

    public static void zeroMemory(ByteBuffer buf, int off, int len) {
        if (buf.isDirect()) {
            GridUnsafe.zeroMemory(GridUnsafe.bufferAddress(buf) + (long)off, len);
        } else {
            for (int i = off; i < off + len; ++i) {
                buf.put(i, (byte)0);
            }
        }
    }

    public static void copyMemory(long srcAddr, long srcOff, long dstAddr, long dstOff, long cnt) {
        GridUnsafe.copyMemory(null, srcAddr + srcOff, null, dstAddr + dstOff, cnt);
    }

    public static void zeroMemory(long addr, int off, int len) {
        GridUnsafe.zeroMemory(addr + (long)off, len);
    }
}

