/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence.snapshot;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.internal.dto.IgniteDataTransferObject;
import org.apache.ignite.internal.processors.cache.persistence.snapshot.SnapshotMetadata;
import org.apache.ignite.internal.processors.cache.verify.IdleVerifyResultV2;
import org.apache.ignite.internal.util.GridStringBuilder;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.jetbrains.annotations.Nullable;

public class SnapshotPartitionsVerifyTaskResult
extends IgniteDataTransferObject {
    private static final long serialVersionUID = 0L;
    private Map<ClusterNode, List<SnapshotMetadata>> metas;
    @Nullable
    private IdleVerifyResultV2 idleRes;

    public SnapshotPartitionsVerifyTaskResult() {
    }

    public SnapshotPartitionsVerifyTaskResult(Map<ClusterNode, List<SnapshotMetadata>> metas, @Nullable IdleVerifyResultV2 idleRes) {
        this.metas = metas;
        this.idleRes = idleRes;
    }

    public Map<ClusterNode, List<SnapshotMetadata>> metas() {
        return this.metas;
    }

    public void print(Consumer<String> printer) {
        Collection wrns;
        if (this.idleRes != null) {
            this.idleRes.print(printer, true);
            if (!F.isEmpty(this.idleRes.exceptions())) {
                return;
            }
        }
        if (!F.isEmpty(wrns = F.flatCollections(F.viewReadOnly(F.flatCollections(this.metas.values()).stream().distinct().collect(Collectors.toList()), SnapshotMetadata::warnings, meta -> meta != null && !F.isEmpty(meta.warnings()))))) {
            GridStringBuilder sb = new GridStringBuilder("This snapshot was created with the warnings:").a(wrns.stream().collect(Collectors.joining("", U.nl() + "\t- ", ""))).nl();
            printer.accept(sb.toString());
        }
    }

    public IdleVerifyResultV2 idleVerifyResult() {
        return this.idleRes;
    }

    public Map<ClusterNode, Exception> exceptions() {
        return this.idleRes == null ? Collections.emptyMap() : this.idleRes.exceptions();
    }

    @Override
    protected void writeExternalData(ObjectOutput out) throws IOException {
        U.writeMap(out, this.metas);
        out.writeObject(this.idleRes);
    }

    @Override
    protected void readExternalData(byte protoVer, ObjectInput in) throws IOException, ClassNotFoundException {
        this.metas = U.readMap(in);
        this.idleRes = (IdleVerifyResultV2)in.readObject();
    }
}

