/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence.snapshot;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiConsumer;
import org.apache.ignite.IgniteException;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.IgniteInterruptedCheckedException;
import org.apache.ignite.internal.MarshallerContextImpl;
import org.apache.ignite.internal.binary.BinaryUtils;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.processors.cache.binary.CacheObjectBinaryProcessorImpl;
import org.apache.ignite.internal.processors.cache.persistence.file.FileIOFactory;
import org.apache.ignite.internal.processors.cache.persistence.partstate.GroupPartitionId;
import org.apache.ignite.internal.processors.cache.persistence.snapshot.AbstractSnapshotFutureTask;
import org.apache.ignite.internal.processors.cache.persistence.snapshot.IgniteSnapshotManager;
import org.apache.ignite.internal.processors.cache.persistence.snapshot.SnapshotMetadata;
import org.apache.ignite.internal.processors.cache.persistence.snapshot.SnapshotSender;
import org.apache.ignite.internal.processors.cache.persistence.wal.WALPointer;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.jetbrains.annotations.Nullable;

class IncrementalSnapshotFutureTask
extends AbstractSnapshotFutureTask<Void>
implements BiConsumer<String, File> {
    private final int incIdx;
    @Nullable
    private final String snpPath;
    private final Set<Integer> affectedCacheGrps;
    private final WALPointer lowPtr;
    private final IgniteInternalFuture<WALPointer> highPtrFut;

    public IncrementalSnapshotFutureTask(GridCacheSharedContext<?, ?> cctx, UUID srcNodeId, UUID reqNodeId, SnapshotMetadata meta, @Nullable String snpPath, int incIdx, File tmpWorkDir, FileIOFactory ioFactory, WALPointer lowPtr, IgniteInternalFuture<WALPointer> highPtrFut) {
        super(cctx, srcNodeId, reqNodeId, meta.snapshotName(), tmpWorkDir, ioFactory, new SnapshotSender(cctx.logger(IncrementalSnapshotFutureTask.class), cctx.kernalContext().pools().getSnapshotExecutorService()){

            @Override
            protected void init(int partsCnt) {
            }

            @Override
            protected void sendPart0(File part, String cacheDirName, GroupPartitionId pair, Long length) {
            }

            @Override
            protected void sendDelta0(File delta, String cacheDirName, GroupPartitionId pair) {
            }
        }, null);
        this.incIdx = incIdx;
        this.snpPath = snpPath;
        this.affectedCacheGrps = new HashSet<Integer>(meta.cacheGroupIds());
        this.lowPtr = lowPtr;
        this.highPtrFut = highPtrFut;
        cctx.cache().configManager().addConfigurationChangeListener(this);
    }

    @Override
    public Set<Integer> affectedCacheGroups() {
        return this.affectedCacheGrps;
    }

    @Override
    public boolean start() {
        try {
            File incSnpDir = this.cctx.snapshotMgr().incrementalSnapshotLocalDir(this.snpName, this.snpPath, this.incIdx);
            if (!incSnpDir.mkdirs() && !incSnpDir.exists()) {
                this.onDone(new IgniteException("Can't create snapshot directory [dir=" + incSnpDir.getAbsolutePath() + ']'));
                boolean bl = false;
                return bl;
            }
            this.highPtrFut.chain(fut -> {
                if (fut.error() != null) {
                    this.onDone(fut.error());
                    return null;
                }
                try {
                    String folderName = this.cctx.kernalContext().pdsFolderResolver().resolveFolders().folderName();
                    this.copyWal(IgniteSnapshotManager.incrementalSnapshotWalsDir(incSnpDir, folderName), (WALPointer)fut.result());
                    this.copyFiles(MarshallerContextImpl.mappingFileStoreWorkDir(this.cctx.gridConfig().getWorkDirectory()), MarshallerContextImpl.mappingFileStoreWorkDir(incSnpDir.getAbsolutePath()), BinaryUtils::notTmpFile);
                    this.copyFiles(CacheObjectBinaryProcessorImpl.binaryWorkDir(this.cctx.gridConfig().getWorkDirectory(), folderName), CacheObjectBinaryProcessorImpl.binaryWorkDir(incSnpDir.getAbsolutePath(), folderName), file -> file.getName().endsWith(".bin"));
                    this.onDone();
                }
                catch (Throwable e) {
                    this.onDone(e);
                }
                return null;
            }, this.cctx.kernalContext().pools().getSnapshotExecutorService());
            boolean bl = true;
            return bl;
        }
        finally {
            this.cctx.cache().configManager().removeConfigurationChangeListener(this);
        }
    }

    private void copyWal(File incSnpWalDir, WALPointer highPtr) throws IgniteInterruptedCheckedException, IOException {
        long lowIdx = this.lowPtr.index() + (long)(this.incIdx == 1 ? 0 : 1);
        long highIdx = highPtr.index();
        assert (this.cctx.gridConfig().getDataStorageConfiguration().isWalCompactionEnabled()) : "WAL Compaction must be enabled";
        assert (lowIdx <= highIdx);
        if (this.log.isInfoEnabled()) {
            this.log.info("Waiting for WAL segments compression [lowIdx=" + lowIdx + ", highIdx=" + highIdx + ']');
        }
        this.cctx.wal().awaitCompacted(highPtr.index());
        if (this.log.isInfoEnabled()) {
            this.log.info("Linking WAL segments into incremental snapshot [lowIdx=" + lowIdx + ", highIdx=" + highIdx + ']');
        }
        if (!incSnpWalDir.mkdirs() && !incSnpWalDir.exists()) {
            throw new IgniteException("Failed to create snapshot WAL directory [idx=" + incSnpWalDir + ']');
        }
        while (lowIdx <= highIdx) {
            File seg = this.cctx.wal().compactedSegment(lowIdx);
            if (!seg.exists()) {
                throw new IgniteException("WAL segment not found in archive [idx=" + lowIdx + ']');
            }
            Path segLink = incSnpWalDir.toPath().resolve(seg.getName());
            if (this.log.isDebugEnabled()) {
                this.log.debug("Creaing segment link [path=" + segLink.toAbsolutePath() + ']');
            }
            Files.createLink(segLink, seg.toPath());
            ++lowIdx;
        }
    }

    private void copyFiles(File fromDir, File toDir, FileFilter filter) throws IOException {
        assert (fromDir.exists() && fromDir.isDirectory());
        if (!(toDir.isDirectory() || toDir.mkdirs() || toDir.exists())) {
            throw new IgniteException("Target directory can't be created [target=" + toDir.getAbsolutePath() + ']');
        }
        for (File from : fromDir.listFiles(filter)) {
            try {
                Files.copy(from.toPath(), new File(toDir, from.getName()).toPath(), new CopyOption[0]);
            }
            catch (FileAlreadyExistsException fileAlreadyExistsException) {
                // empty catch block
            }
        }
    }

    @Override
    public void acceptException(Throwable th) {
        this.cctx.cache().configManager().removeConfigurationChangeListener(this);
        this.onDone(th);
    }

    @Override
    public void accept(String name, File file) {
        this.onDone(new IgniteException(IgniteSnapshotManager.cacheChangedException(CU.cacheId(name), name)));
    }
}

