/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence.file;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.ClosedByInterruptException;
import java.nio.channels.ClosedChannelException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.LongConsumer;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteSystemProperties;
import org.apache.ignite.internal.pagemem.PageIdUtils;
import org.apache.ignite.internal.pagemem.store.PageStore;
import org.apache.ignite.internal.pagemem.store.PageWriteListener;
import org.apache.ignite.internal.processors.cache.persistence.StorageException;
import org.apache.ignite.internal.processors.cache.persistence.file.FileIO;
import org.apache.ignite.internal.processors.cache.persistence.file.FileIOFactory;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.PageIO;
import org.apache.ignite.internal.processors.cache.persistence.wal.crc.FastCrc;
import org.apache.ignite.internal.processors.cache.persistence.wal.crc.IgniteDataIntegrityViolationException;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteOutClosure;

public class FilePageStore
implements PageStore {
    private static final long SIGNATURE = -1037300167331204936L;
    public static final int VERSION = 1;
    public static final int HEADER_SIZE = 17;
    private final IgniteOutClosure<Path> pathProvider;
    private volatile Boolean fileExists;
    private final byte type;
    private final FileIOFactory ioFactory;
    protected volatile FileIO fileIO;
    private final AtomicLong allocated;
    private final LongConsumer allocatedTracker;
    private final List<PageWriteListener> lsnrs = new CopyOnWriteArrayList<PageWriteListener>();
    protected final int pageSize;
    private volatile boolean inited;
    private volatile boolean recover;
    private volatile int tag;
    private final boolean skipCrc = IgniteSystemProperties.getBoolean("IGNITE_PDS_SKIP_CRC");
    private final ReadWriteLock lock = new ReentrantReadWriteLock();

    public FilePageStore(byte type, IgniteOutClosure<Path> pathProvider, FileIOFactory factory, int pageSize, LongConsumer allocatedTracker) {
        assert (type == 1 || type == 2) : type;
        this.type = type;
        this.pathProvider = pathProvider;
        this.ioFactory = factory;
        this.allocated = new AtomicLong();
        this.pageSize = pageSize;
        this.allocatedTracker = allocatedTracker;
    }

    @Override
    public void addWriteListener(PageWriteListener lsnr) {
        this.lsnrs.add(lsnr);
    }

    @Override
    public void removeWriteListener(PageWriteListener lsnr) {
        this.lsnrs.remove(lsnr);
    }

    @Override
    public int getPageSize() {
        return this.pageSize;
    }

    @Override
    public int getBlockSize() {
        return -1;
    }

    @Override
    public long size() {
        try {
            FileIO io = this.fileIO;
            return io == null ? 0L : io.size();
        }
        catch (IOException e) {
            throw new IgniteException(e);
        }
    }

    @Override
    public long getSparseSize() {
        return -1L;
    }

    @Override
    public void punchHole(long pageId, int usefulBytes) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean exists() {
        if (this.fileExists == null) {
            this.lock.writeLock().lock();
            try {
                if (this.fileExists == null) {
                    File file = this.pathProvider.apply().toFile();
                    this.fileExists = file.exists() && file.length() > (long)this.headerSize();
                }
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }
        return this.fileExists;
    }

    public int headerSize() {
        return 17;
    }

    @Override
    public int version() {
        return 1;
    }

    public ByteBuffer header(byte type, int pageSize) {
        ByteBuffer hdr = ByteBuffer.allocate(this.headerSize()).order(ByteOrder.nativeOrder());
        hdr.putLong(-1037300167331204936L);
        hdr.putInt(this.version());
        hdr.put(type);
        hdr.putInt(pageSize);
        hdr.rewind();
        return hdr;
    }

    private long initFile(FileIO fileIO) throws IOException {
        try {
            ByteBuffer hdr = this.header(this.type, this.pageSize);
            fileIO.writeFully(hdr);
            return this.headerSize() + this.pageSize;
        }
        catch (ClosedByInterruptException e) {
            this.lock.writeLock().lock();
            try {
                Files.delete(this.pathProvider.apply());
                this.fileExists = false;
            }
            finally {
                this.lock.writeLock().unlock();
            }
            throw e;
        }
    }

    private long checkFile(FileIO fileIO, File cfgFile) throws IOException {
        ByteBuffer hdr = ByteBuffer.allocate(this.headerSize()).order(ByteOrder.nativeOrder());
        fileIO.readFully(hdr);
        hdr.rewind();
        long signature = hdr.getLong();
        String prefix = "Failed to verify, file=" + cfgFile.getAbsolutePath() + "\" ";
        if (-1037300167331204936L != signature) {
            throw new IOException(prefix + "(invalid file signature) [expectedSignature=" + U.hexLong(-1037300167331204936L) + ", actualSignature=" + U.hexLong(signature) + ']');
        }
        int ver = hdr.getInt();
        if (this.version() != ver) {
            throw new IOException(prefix + "(invalid file version) [expectedVersion=" + this.version() + ", fileVersion=" + ver + "]");
        }
        byte type = hdr.get();
        if (this.type != type) {
            throw new IOException(prefix + "(invalid file type) [expectedFileType=" + this.type + ", actualFileType=" + type + "]");
        }
        int pageSize = hdr.getInt();
        if (this.pageSize != pageSize) {
            throw new IOException(prefix + "(invalid page size) [expectedPageSize=" + this.pageSize + ", filePageSize=" + pageSize + "]");
        }
        long fileSize = cfgFile.length();
        if (fileSize == (long)this.headerSize()) {
            fileSize = pageSize + this.headerSize();
        }
        if (fileSize % (long)pageSize != 0L) {
            fileSize = (fileSize / (long)pageSize + 1L) * (long)pageSize;
        }
        return fileSize;
    }

    private void stop0(boolean delete) throws IOException {
        this.lock.writeLock().lock();
        try {
            if (!this.inited) {
                if (this.fileIO != null) {
                    this.fileIO.close();
                }
                if (delete && this.exists()) {
                    Files.delete(this.pathProvider.apply().toAbsolutePath());
                }
                return;
            }
            this.fileIO.force();
            this.fileIO.close();
            this.fileIO = null;
            if (delete) {
                Files.delete(this.pathProvider.apply());
                this.fileExists = false;
            }
        }
        finally {
            this.allocatedTracker.accept(-1L * this.allocated.getAndSet(0L) / (long)this.pageSize);
            this.inited = false;
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public void stop(boolean delete) throws StorageException {
        try {
            this.stop0(delete);
        }
        catch (IOException e) {
            throw new StorageException("Failed to stop serving partition file [file=" + this.getFileAbsolutePath() + ", delete=" + delete + "]", e);
        }
    }

    @Override
    public void close() throws IOException {
        this.stop0(false);
    }

    @Override
    public void truncate(int tag) throws StorageException {
        this.init();
        Path filePath = this.pathProvider.apply();
        this.lock.writeLock().lock();
        try {
            this.tag = tag;
            this.fileIO.clear();
            this.fileIO.close();
            this.fileIO = null;
            Files.delete(filePath);
            this.fileExists = false;
        }
        catch (IOException e) {
            throw new StorageException("Failed to truncate partition file [file=" + filePath.toAbsolutePath() + "]", e);
        }
        finally {
            this.allocatedTracker.accept(-1L * this.allocated.getAndSet(0L) / (long)this.pageSize);
            this.inited = false;
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public void beginRecover() {
        this.lock.writeLock().lock();
        try {
            this.recover = true;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public void finishRecover() throws StorageException {
        this.lock.writeLock().lock();
        try {
            if (this.inited) {
                long newSize = Math.max((long)this.pageSize, this.fileIO.size() - (long)this.headerSize());
                if (newSize % (long)this.pageSize != 0L) {
                    newSize += (long)this.pageSize - newSize % (long)this.pageSize;
                }
                long delta = newSize - this.allocated.getAndSet(newSize);
                assert (delta % (long)this.pageSize == 0L) : delta;
                this.allocatedTracker.accept(delta / (long)this.pageSize);
            }
            this.recover = false;
        }
        catch (IOException e) {
            throw new StorageException("Failed to finish recover partition file [file=" + this.getFileAbsolutePath() + "]", e);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    private int getCrcSize(long pageId, ByteBuffer pageBuf) throws IOException {
        short compressedSize = PageIO.getCompressedSize(pageBuf);
        if (compressedSize == 0) {
            return this.pageSize;
        }
        if (compressedSize < 0 || compressedSize > this.pageSize) {
            throw new IgniteDataIntegrityViolationException("Failed to read page (CRC validation failed) [id=" + U.hexLong(pageId) + ", file=" + this.getFileAbsolutePath() + ", fileSize=" + this.fileIO.size() + ", page=" + U.toHexString(pageBuf) + "]");
        }
        return compressedSize;
    }

    @Override
    public boolean read(long pageId, ByteBuffer pageBuf, boolean keepCrc) throws IgniteCheckedException {
        return this.read(pageId, pageBuf, !this.skipCrc, keepCrc);
    }

    public boolean read(long pageId, ByteBuffer pageBuf, boolean checkCrc, boolean keepCrc) throws IgniteCheckedException {
        this.init();
        try {
            int curCrc32;
            long off = this.pageOffset(pageId);
            assert (pageBuf.capacity() == this.pageSize);
            assert (pageBuf.remaining() == this.pageSize);
            assert (pageBuf.position() == 0);
            assert (pageBuf.order() == ByteOrder.nativeOrder());
            assert (off <= this.allocated.get()) : "calculatedOffset=" + off + ", allocated=" + this.allocated.get() + ", headerSize=" + this.headerSize() + ", cfgFile=" + this.pathProvider.apply().toAbsolutePath();
            int n = this.readWithFailover(pageBuf, off);
            if (n < 0) {
                pageBuf.put(new byte[pageBuf.remaining()]);
                return false;
            }
            int savedCrc32 = PageIO.getCrc(pageBuf);
            PageIO.setCrc(pageBuf, 0);
            pageBuf.position(0);
            if (checkCrc && (savedCrc32 ^ (curCrc32 = FastCrc.calcCrc(pageBuf, this.getCrcSize(pageId, pageBuf)))) != 0) {
                throw new IgniteDataIntegrityViolationException("Failed to read page (CRC validation failed) [id=" + U.hexLong(pageId) + ", off=" + (off - (long)this.pageSize) + ", file=" + this.getFileAbsolutePath() + ", fileSize=" + this.fileIO.size() + ", savedCrc=" + U.hexInt(savedCrc32) + ", curCrc=" + U.hexInt(curCrc32) + ", page=" + U.toHexString(pageBuf) + "]");
            }
            assert (PageIO.getCrc(pageBuf) == 0);
            if (keepCrc) {
                PageIO.setCrc(pageBuf, savedCrc32);
            }
            return true;
        }
        catch (IOException e) {
            throw new StorageException("Failed to read page [file=" + this.getFileAbsolutePath() + ", pageId=" + pageId + "]", e);
        }
    }

    @Override
    public void readHeader(ByteBuffer buf) throws IgniteCheckedException {
        this.init();
        try {
            assert (buf.remaining() == this.headerSize());
            this.readWithFailover(buf, 0L);
        }
        catch (IOException e) {
            throw new StorageException("Failed to read header [file=" + this.getFileAbsolutePath() + "]", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() throws StorageException {
        block18: {
            if (!this.inited) {
                this.lock.writeLock().lock();
                try {
                    if (this.inited) break block18;
                    FileIO fileIO = null;
                    Throwable err = null;
                    try {
                        long newSize;
                        boolean interrupted = false;
                        while (true) {
                            try {
                                File cfgFile = this.pathProvider.apply().toFile();
                                this.fileIO = fileIO = this.ioFactory.create(cfgFile, StandardOpenOption.CREATE, StandardOpenOption.READ, StandardOpenOption.WRITE);
                                this.fileExists = true;
                                newSize = (cfgFile.length() == 0L ? this.initFile(fileIO) : this.checkFile(fileIO, cfgFile)) - (long)this.headerSize();
                                if (!interrupted) break;
                                Thread.currentThread().interrupt();
                            }
                            catch (ClosedByInterruptException e) {
                                interrupted = true;
                                Thread.interrupted();
                                continue;
                            }
                            break;
                        }
                        assert (this.allocated.get() == 0L);
                        this.allocated.set(newSize);
                        this.inited = true;
                        this.allocatedTracker.accept(this.pages());
                    }
                    catch (IOException e) {
                        err = new StorageException("Failed to initialize partition file: " + this.getFileAbsolutePath(), e);
                        throw err;
                    }
                    finally {
                        if (err != null && fileIO != null) {
                            try {
                                fileIO.close();
                            }
                            catch (IOException e) {
                                err.addSuppressed(e);
                            }
                        }
                    }
                }
                finally {
                    this.lock.writeLock().unlock();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reinit(FileIO fileIO) throws IOException {
        if (!this.inited) {
            return;
        }
        if (fileIO != this.fileIO) {
            return;
        }
        this.lock.writeLock().lock();
        try {
            if (fileIO != this.fileIO) {
                return;
            }
            try {
                boolean interrupted = false;
                while (true) {
                    try {
                        fileIO = null;
                        File cfgFile = this.pathProvider.apply().toFile();
                        fileIO = this.ioFactory.create(cfgFile, StandardOpenOption.CREATE, StandardOpenOption.READ, StandardOpenOption.WRITE);
                        this.fileExists = true;
                        this.checkFile(fileIO, cfgFile);
                        this.fileIO = fileIO;
                        if (interrupted) {
                            Thread.currentThread().interrupt();
                        }
                    }
                    catch (ClosedByInterruptException e) {
                        interrupted = true;
                        Thread.interrupted();
                        continue;
                    }
                    break;
                }
            }
            catch (IOException e) {
                try {
                    if (fileIO != null) {
                        fileIO.close();
                    }
                }
                catch (IOException e0) {
                    e.addSuppressed(e0);
                }
                throw e;
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(long pageId, ByteBuffer pageBuf, int tag, boolean calculateCrc) throws IgniteCheckedException {
        this.init();
        boolean interrupted = false;
        while (true) {
            FileIO fileIO = this.fileIO;
            try {
                this.lock.readLock().lock();
                try {
                    if (tag < this.tag) {
                        return;
                    }
                    long off = this.pageOffset(pageId);
                    assert (off >= 0L && off <= this.allocated.get() || this.recover) : "off=" + U.hexLong(off) + ", allocated=" + U.hexLong(this.allocated.get()) + ", pageId=" + U.hexLong(pageId) + ", file=" + this.getFileAbsolutePath();
                    assert (pageBuf.position() == 0);
                    assert (pageBuf.order() == ByteOrder.nativeOrder()) : "Page buffer order " + pageBuf.order() + " should be same with " + ByteOrder.nativeOrder();
                    assert (PageIO.getType(pageBuf) != 0) : "Invalid state. Type is 0! pageId = " + U.hexLong(pageId);
                    assert (PageIO.getVersion(pageBuf) != 0) : "Invalid state. Version is 0! pageId = " + U.hexLong(pageId);
                    if (calculateCrc && !this.skipCrc) {
                        assert (PageIO.getCrc(pageBuf) == 0) : U.hexLong(pageId);
                        PageIO.setCrc(pageBuf, FilePageStore.calcCrc32(pageBuf, this.getCrcSize(pageId, pageBuf)));
                    }
                    assert (this.skipCrc || PageIO.getCrc(pageBuf) != 0 || FilePageStore.calcCrc32(pageBuf, this.getCrcSize(pageId, pageBuf)) == 0) : "CRC hasn't been calculated, crc=0";
                    assert (pageBuf.position() == 0) : pageBuf.position();
                    for (PageWriteListener lsnr : this.lsnrs) {
                        lsnr.accept(pageId, pageBuf);
                        pageBuf.rewind();
                    }
                    fileIO.writeFully(pageBuf, off);
                    PageIO.setCrc(pageBuf, 0);
                    if (interrupted) {
                        Thread.currentThread().interrupt();
                    }
                    return;
                }
                finally {
                    this.lock.readLock().unlock();
                }
            }
            catch (IOException e) {
                block23: {
                    if (e instanceof ClosedChannelException) {
                        try {
                            if (e instanceof ClosedByInterruptException) {
                                interrupted = true;
                                Thread.interrupted();
                            }
                            this.reinit(fileIO);
                            pageBuf.position(0);
                            PageIO.setCrc(pageBuf, 0);
                        }
                        catch (IOException e0) {
                            e0.addSuppressed(e);
                            e = e0;
                            break block23;
                        }
                        continue;
                    }
                }
                throw new StorageException("Failed to write page [file=" + this.getFileAbsolutePath() + ", pageId=" + pageId + ", tag=" + tag + "]", e);
            }
            break;
        }
    }

    private static int calcCrc32(ByteBuffer pageBuf, int pageSize) {
        try {
            pageBuf.position(0);
            int n = FastCrc.calcCrc(pageBuf, pageSize);
            return n;
        }
        finally {
            pageBuf.position(0);
        }
    }

    @Override
    public long pageOffset(long pageId) {
        return (long)PageIdUtils.pageIndex(pageId) * (long)this.pageSize + (long)this.headerSize();
    }

    @Override
    public void sync() throws StorageException {
        this.lock.writeLock().lock();
        try {
            this.init();
            FileIO fileIO = this.fileIO;
            if (fileIO != null) {
                fileIO.force();
            }
        }
        catch (IOException e) {
            throw new StorageException("Failed to fsync partition file [file=" + this.getFileAbsolutePath() + ']', e);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public synchronized void ensure() throws IgniteCheckedException {
        this.init();
    }

    @Override
    public long allocatePage() throws IgniteCheckedException {
        this.init();
        return this.allocPage() / (long)this.pageSize;
    }

    public String getFileAbsolutePath() {
        return this.pathProvider.apply().toAbsolutePath().toString();
    }

    private long allocPage() {
        long off;
        while (!this.allocated.compareAndSet(off = this.allocated.get(), off + (long)this.pageSize)) {
        }
        this.allocatedTracker.accept(1L);
        return off;
    }

    @Override
    public int pages() {
        if (!this.inited) {
            return 0;
        }
        return (int)(this.allocated.get() / (long)this.pageSize);
    }

    private int readWithFailover(ByteBuffer destBuf, long position) throws IOException {
        boolean interrupted = false;
        int bufPos = destBuf.position();
        while (true) {
            FileIO fileIO;
            if ((fileIO = this.fileIO) == null) {
                throw new IOException("FileIO has stopped");
            }
            try {
                assert (destBuf.remaining() > 0);
                int bytesRead = fileIO.readFully(destBuf, position);
                if (interrupted) {
                    Thread.currentThread().interrupt();
                }
                return bytesRead;
            }
            catch (ClosedChannelException e) {
                destBuf.position(bufPos);
                if (e instanceof ClosedByInterruptException) {
                    interrupted = true;
                    Thread.interrupted();
                }
                this.reinit(fileIO);
                continue;
            }
            break;
        }
    }
}

